/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.params.ParameterizedTestMethodContext;
import org.junit.jupiter.params.ParameterizedTestNameFormatter;
import org.junit.jupiter.params.ParameterizedTestParameterResolver;
import org.junit.jupiter.params.provider.Arguments;

class ParameterizedTestInvocationContext
implements TestTemplateInvocationContext {
    private final ParameterizedTestNameFormatter formatter;
    private final ParameterizedTestMethodContext methodContext;
    private final Arguments arguments;
    private final Object[] consumedArguments;
    private final int invocationIndex;

    ParameterizedTestInvocationContext(ParameterizedTestNameFormatter formatter, ParameterizedTestMethodContext methodContext, Arguments arguments, int invocationIndex) {
        this.formatter = formatter;
        this.methodContext = methodContext;
        this.arguments = arguments;
        this.consumedArguments = ParameterizedTestInvocationContext.consumedArguments(methodContext, arguments.get());
        this.invocationIndex = invocationIndex;
    }

    public String getDisplayName(int invocationIndex) {
        return this.formatter.format(invocationIndex, this.arguments, this.consumedArguments);
    }

    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList(new ParameterizedTestParameterResolver(this.methodContext, this.consumedArguments, this.invocationIndex));
    }

    private static Object[] consumedArguments(ParameterizedTestMethodContext methodContext, Object[] arguments) {
        if (methodContext.hasAggregator()) {
            return arguments;
        }
        int parameterCount = methodContext.getParameterCount();
        return arguments.length > parameterCount ? Arrays.copyOf(arguments, parameterCount) : arguments;
    }
}

