/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.graph;

import java.util.Iterator;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.gmf.runtime.draw2d.ui.graph.BorderNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstantSizeNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstrainedEdge;
import org.eclipse.gmf.runtime.draw2d.ui.graph.JointEdges;

class GraphUtilities {
    GraphUtilities() {
    }

    static void transpose(DirectedGraph g) {
        int i = 0;
        while (i < g.nodes.size()) {
            GraphUtilities.transpose(g.nodes.getNode(i));
            ++i;
        }
        i = 0;
        while (i < g.edges.size()) {
            GraphUtilities.transpose(g.edges.getEdge(i));
            ++i;
        }
        g.getLayoutSize().transpose();
        g.getDefaultPadding().transpose();
        if (g instanceof CompoundDirectedGraph) {
            CompoundDirectedGraph cg = (CompoundDirectedGraph)g;
            int i2 = 0;
            while (i2 < cg.subgraphs.size()) {
                GraphUtilities.transpose(cg.subgraphs.getNode(i2));
                ++i2;
            }
        }
    }

    private static void transpose(Node n) {
        int temp = n.x;
        n.x = n.y;
        n.y = temp;
        temp = n.width;
        n.width = n.height;
        n.height = temp;
        if (n.getPadding() != null) {
            n.getPadding().transpose();
        }
        if (n instanceof ConstantSizeNode) {
            Iterator<BorderNode> itr = ((ConstantSizeNode)n).borderNodes.iterator();
            while (itr.hasNext()) {
                GraphUtilities.transpose(itr.next());
            }
        }
    }

    private static void transpose(Edge e) {
        e.start.transpose();
        e.end.transpose();
        e.getPoints().transpose();
        if (e.vNodes != null) {
            int i = 0;
            while (i < e.vNodes.size()) {
                GraphUtilities.transpose(e.vNodes.getNode(i));
                ++i;
            }
        }
    }

    static void storeNodesSizes(DirectedGraph g) {
        int i = 0;
        while (i < g.nodes.size()) {
            Node n = g.nodes.getNode(i);
            if (n instanceof ConstantSizeNode) {
                ConstantSizeNode cn = (ConstantSizeNode)n;
                cn.constantWidth = cn.width;
                cn.constantHeight = cn.height;
            }
            ++i;
        }
    }

    static void recallNodesSizes(DirectedGraph g) {
        int i = 0;
        while (i < g.nodes.size()) {
            Node n = g.nodes.getNode(i);
            if (n instanceof ConstantSizeNode) {
                ConstantSizeNode cn = (ConstantSizeNode)n;
                cn.width = cn.constantWidth;
                cn.height = cn.constantHeight;
            }
            ++i;
        }
    }

    static int getRankHeightFromNode(Node n, DirectedGraph g) {
        int rankHeight = -1;
        Rank rank = GraphUtilities.getNodeRank(n, g);
        if (rank != null) {
            int i = 0;
            while (i < rank.size()) {
                rankHeight = Math.max(rankHeight, rank.getNode((int)i).height);
                ++i;
            }
        }
        return rankHeight;
    }

    static Rank getNodeRank(Node n, DirectedGraph g) {
        int i = 0;
        while (i < g.ranks.size()) {
            Rank rank = g.ranks.getRank(i);
            if (!rank.isEmpty() && n.y == rank.getNode((int)0).y) {
                return rank;
            }
            ++i;
        }
        return null;
    }

    static int getOutogingEdgeBendpointX(Edge e, DirectedGraph g) {
        int targetX;
        if (e instanceof JointEdges) {
            return GraphUtilities.getOutogingEdgeBendpointX(((JointEdges)e).getLeadingEdge(), g);
        }
        if (e.vNodes == null) {
            if (e.end != null) {
                return e.end.x;
            }
            int sourceX = e.source.x + e.source.getOffsetOutgoing();
            if (e.target instanceof ConstantSizeNode && ((ConstantSizeNode)e.target).getMinIncomingPadding() > 0 && e.target.x < sourceX && sourceX < e.target.x + e.target.width) {
                return sourceX;
            }
            return e.target.x + e.target.getOffsetIncoming();
        }
        Node vn = e.vNodes.getNode(0);
        if (e instanceof ConstrainedEdge && ((ConstrainedEdge)e).getStyle().equals("Orthogonal")) {
            return vn.x + vn.getOffsetIncoming();
        }
        int leftX = Integer.MIN_VALUE;
        int rightX = Integer.MAX_VALUE;
        int i = e.vNodes.size() - 1;
        while (i >= 0) {
            vn = e.vNodes.getNode(i);
            int currentLeftX = GraphUtilities.getLeftX(vn, e, g);
            int currentRightX = GraphUtilities.getRightX(vn, e, g);
            if (currentLeftX > rightX) {
                return rightX;
            }
            if (currentRightX < leftX) {
                return leftX;
            }
            if (currentLeftX > leftX) {
                leftX = currentLeftX;
            }
            if (currentRightX < rightX) {
                rightX = currentRightX;
            }
            --i;
        }
        int n = targetX = e.end != null ? e.end.x : e.target.x + e.target.getOffsetIncoming();
        if (targetX > rightX) {
            return rightX;
        }
        if (targetX < leftX) {
            return leftX;
        }
        return targetX;
    }

    static int getIncomingEdgeBendpointX(Edge e, DirectedGraph g) {
        int sourceX;
        if (e instanceof JointEdges) {
            return GraphUtilities.getIncomingEdgeBendpointX(((JointEdges)e).getLeadingEdge(), g);
        }
        if (e.vNodes == null) {
            if (e.start != null) {
                return e.start.x;
            }
            int targetX = e.target.x + e.target.getOffsetIncoming();
            if (e.source instanceof ConstantSizeNode && ((ConstantSizeNode)e.source).getMinOutgoingPadding() > 0 && e.source.x < targetX && targetX < e.source.x + e.source.width) {
                return targetX;
            }
            return e.source.x + e.source.getOffsetOutgoing();
        }
        Node vn = e.vNodes.getNode(e.vNodes.size() - 1);
        if (e instanceof ConstrainedEdge && ((ConstrainedEdge)e).getStyle().equals("Orthogonal")) {
            return vn.x + vn.getOffsetOutgoing();
        }
        int leftX = Integer.MIN_VALUE;
        int rightX = Integer.MAX_VALUE;
        int i = e.vNodes.size() - 1;
        while (i >= 0) {
            vn = e.vNodes.getNode(i);
            int currentLeftX = GraphUtilities.getLeftX(vn, e, g);
            int currentRightX = GraphUtilities.getRightX(vn, e, g);
            if (currentLeftX > rightX) {
                return rightX;
            }
            if (currentRightX < leftX) {
                return leftX;
            }
            if (currentLeftX > leftX) {
                leftX = currentLeftX;
            }
            if (currentRightX < rightX) {
                rightX = currentRightX;
            }
            --i;
        }
        int n = sourceX = e.start != null ? e.start.x : e.source.x + e.source.getOffsetOutgoing();
        if (sourceX > rightX) {
            return rightX;
        }
        if (sourceX < leftX) {
            return leftX;
        }
        return sourceX;
    }

    private static int getLeftX(Node vn, Edge e, DirectedGraph g) {
        return vn.getLeft() != null ? vn.getLeft().x + vn.getLeft().width + g.getPadding((Node)vn.getLeft()).right + e.getPadding() - 1 : 0;
    }

    private static int getRightX(Node vn, Edge e, DirectedGraph g) {
        return vn.getRight() != null ? vn.getRight().x - g.getPadding((Node)vn.getRight()).left - e.getPadding() + 1 : g.getLayoutSize().width;
    }

    static void translateGraph(DirectedGraph g, int x, int y) {
        int i = 0;
        while (i < g.nodes.size()) {
            GraphUtilities.translateNode(g.nodes.getNode(i), x, y);
            ++i;
        }
        i = 0;
        while (i < g.edges.size()) {
            GraphUtilities.translateEdge(g.edges.getEdge(i), x, y);
            ++i;
        }
    }

    static void translateNode(Node n, int x, int y) {
        n.x += x;
        n.y += y;
        if (n instanceof ConstantSizeNode) {
            ConstantSizeNode cn = (ConstantSizeNode)n;
            Iterator<BorderNode> itr = cn.borderNodes.iterator();
            while (itr.hasNext()) {
                GraphUtilities.translateNode(itr.next(), x, y);
            }
        }
    }

    static void translateEdge(Edge e, int x, int y) {
        e.start.translate(x, y);
        e.end.translate(x, y);
        e.getPoints().translate(x, y);
    }

    static void invertEdges(DirectedGraph g) {
        int i = 0;
        while (i < g.edges.size()) {
            Edge e = g.edges.getEdge(i);
            if (e.isFeedback()) {
                e.invert();
            }
            ++i;
        }
    }
}

