/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output;

import java.util.EnumSet;
import java.util.Locale;
import org.eclipse.escet.cif.simulator.options.ProfilingOption;
import org.eclipse.escet.cif.simulator.output.DebugOutputType;
import org.eclipse.escet.common.app.framework.options.EnumSetOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class DebugOutputOption
extends EnumSetOption<DebugOutputType> {
    public static final EnumSet<DebugOutputType> DEFAULTS = DebugOutputOption.getDefaults();

    public DebugOutputOption() {
        super("Debug output", DebugOutputOption.getCmdLineDescription(), Character.valueOf('d'), "debug", "DEBUG", DEFAULTS, true, "Indicate which debug output should be printed to the console. If any debug output is enabled, the debug output mode is automatically enabled.", DebugOutputType.class);
    }

    public static EnumSet<DebugOutputType> getDebugTypes() {
        return (EnumSet)Options.get(DebugOutputOption.class);
    }

    public static boolean doPrint(DebugOutputType type) {
        return DebugOutputOption.getDebugTypes().contains((Object)type);
    }

    public void postProcessValue(EnumSet<DebugOutputType> value) {
        if (((Boolean)Options.get(ProfilingOption.class)).booleanValue()) {
            this.clear();
        }
        if (!value.isEmpty()) {
            Options.set(OutputModeOption.class, (Object)OutputMode.DEBUG);
        }
    }

    private static EnumSet<DebugOutputType> getDefaults() {
        return EnumSet.noneOf(DebugOutputType.class);
    }

    public String getDialogText(DebugOutputType literal) {
        return "Debug the " + literal.description;
    }

    private static String getCmdLineDescription() {
        StringBuilder b = new StringBuilder();
        b.append("Specify comma separated names of the desired types of console debug output. If any debug output is specified, the debug output mode is automatically enabled. Specify ");
        DebugOutputType[] literals = (DebugOutputType[])DebugOutputType.class.getEnumConstants();
        Assert.check((literals.length > 1 ? 1 : 0) != 0);
        int i = 0;
        while (i < literals.length - 1) {
            if (i > 0) {
                b.append(", ");
            }
            DebugOutputType literal = literals[i];
            String litTxt = DebugOutputOption.getCmdLineDescription(literal);
            b.append(litTxt);
            ++i;
        }
        b.append(", and/or ");
        b.append(DebugOutputOption.getCmdLineDescription(literals[literals.length - 1]));
        b.append(". Prefix a name with \"+\" to add it on top of the defaults, or with \"-\" to remove it from the defaults.");
        return b.toString();
    }

    private static String getCmdLineDescription(DebugOutputType literal) {
        String valueTxt = literal.name().toLowerCase(Locale.US).replace('_', '-');
        boolean isDefault = DEFAULTS.contains((Object)literal);
        return Strings.fmt((String)"\"%s\" %sto debug the %s", (Object[])new Object[]{valueTxt, isDefault ? "(default) " : "", literal.description});
    }
}

