/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.preprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.properties.Category;
import org.eclipse.sirius.properties.DialogModelOperation;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.core.api.IDescriptionLinkResolver;
import org.eclipse.sirius.properties.core.api.TransformationCache;

public class GroupDescriptionPreprocessorLinkResolver
implements IDescriptionLinkResolver {
    @Override
    public void resolve(EObject eObject, TransformationCache cache) {
        Stream<Object> pages = Stream.empty();
        if (eObject instanceof ViewExtensionDescription) {
            ViewExtensionDescription viewExtensionDescription = (ViewExtensionDescription)eObject;
            pages = viewExtensionDescription.getCategories().stream().map(Category::getPages).flatMap(Collection::stream);
        } else if (eObject instanceof DialogModelOperation) {
            DialogModelOperation dialogModelOperation = (DialogModelOperation)eObject;
            pages = Stream.of(dialogModelOperation.getPage());
        }
        pages.forEach(page -> {
            ArrayList groups = new ArrayList();
            page.getGroups().forEach(group -> {
                if (group.eResource() != null) {
                    cache.getOutput(group).filter(GroupDescription.class::isInstance).map(GroupDescription.class::cast).ifPresent(groups::add);
                } else if (group.eContainer() == null) {
                    EObject eContainer = page.eContainer();
                    if (eContainer instanceof Category) {
                        Category category = (Category)eContainer;
                        category.getGroups().add(group);
                        groups.add(group);
                    } else if (eContainer instanceof DialogModelOperation) {
                        DialogModelOperation dialogModelOperation = (DialogModelOperation)eContainer;
                        dialogModelOperation.getGroups().add(group);
                        groups.add(group);
                    }
                }
            });
            page.getGroups().clear();
            page.getGroups().addAll(groups);
        });
    }
}

