/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.io.conv;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.core.io.conv.Attribute;
import org.eclipse.trace4cps.core.io.conv.Context;

public class Configuration {
    protected static final String CONFIGURATION_VERSION_DEFAULT = null;
    protected String configurationVersion = CONFIGURATION_VERSION_DEFAULT;
    protected static final String CONFIGURATION_SOURCE_DEFAULT = null;
    protected String configurationSource = CONFIGURATION_SOURCE_DEFAULT;
    protected static final String CONFIGURATION_NAME_DEFAULT = null;
    protected String configurationName = CONFIGURATION_NAME_DEFAULT;
    protected static final String CONFIGURATION_ID_DEFAULT = null;
    protected String configurationID = CONFIGURATION_ID_DEFAULT;
    protected static final int TIME_SCALE_SHIFT_DEFAULT = 0;
    protected int timeScaleShift = 0;
    protected static final String TIME_SCALE_UNIT_DEFAULT = "s";
    protected TimeUnit timeScaleUnit = TimeUnit.SECONDS;
    protected static final int TIME_RESOLUTION_SHIFT_DEFAULT = 3;
    protected int timeResolutionShift = 3;
    protected static final String TIME_DISPLAY_FORMAT_DEFAULT = "%.5g";
    protected String timeDisplayFormat = "%.5g";
    protected ArrayList<Attribute> attributes;
    protected HashMap<Integer, Object> idAttributeMap;
    protected HashMap<Object, Integer> attributeIdMap;
    protected ArrayList<Context> contexts;
    protected HashMap<Integer, Object> idContextMap;
    protected HashMap<Object, Integer> contextIdMap;
    protected HashMap<String, Color> colorDefinitionMap;
    protected HashMap<Integer, Object> idQuantityMap;
    private boolean scaleClaimsInActivityViewWithResourceAmount = true;

    protected Configuration() {
    }

    public String getConfigurationID() {
        return this.configurationID;
    }

    public void setConfigurationID(String newConfigurationID) {
        this.configurationID = newConfigurationID;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String newConfigurationName) {
        this.configurationName = newConfigurationName;
    }

    public String getConfigurationVersion() {
        return this.configurationVersion;
    }

    public void setConfigurationVersion(String newConfigurationVersion) {
        this.configurationVersion = newConfigurationVersion;
    }

    public String getConfigurationSource() {
        return this.configurationSource;
    }

    public void setConfigurationSource(String newConfigurationSource) {
        this.configurationSource = newConfigurationSource;
    }

    public int getTimeScaleShift() {
        return this.timeScaleShift;
    }

    public void setTimeScaleShift(int newTimeScaleShift) {
        this.timeScaleShift = newTimeScaleShift;
    }

    public TimeUnit getTimeScaleUnit() {
        return this.timeScaleUnit;
    }

    public boolean setTimeScaleUnit(String newTimeScaleUnit) {
        try {
            this.timeScaleUnit = TimeUnit.valueOf(newTimeScaleUnit);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public int getTimeResolutionShift() {
        return this.timeResolutionShift;
    }

    public void setTimeResolutionShift(int newTimeResolutionShift) {
        this.timeResolutionShift = newTimeResolutionShift;
    }

    public String getTimeDisplayFormat() {
        return this.timeDisplayFormat;
    }

    public void setTimeDisplayFormat(String newTimeDisplayFormat) {
        this.timeDisplayFormat = newTimeDisplayFormat;
    }

    public ArrayList<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        return this.attributes;
    }

    public HashMap<Integer, Object> getIdAttributeMap() {
        if (this.idAttributeMap == null) {
            this.idAttributeMap = new HashMap();
        }
        return this.idAttributeMap;
    }

    public HashMap<Object, Integer> getAttributeIdMap() {
        if (this.attributeIdMap == null) {
            this.attributeIdMap = new HashMap();
        }
        return this.attributeIdMap;
    }

    public ArrayList<Context> getContexts() {
        if (this.contexts == null) {
            this.contexts = new ArrayList();
        }
        return this.contexts;
    }

    public HashMap<Integer, Object> getIdContextMap() {
        if (this.idContextMap == null) {
            this.idContextMap = new HashMap();
        }
        return this.idContextMap;
    }

    public HashMap<Object, Integer> getContextIdMap() {
        if (this.contextIdMap == null) {
            this.contextIdMap = new HashMap();
        }
        return this.contextIdMap;
    }

    public HashMap<String, Color> getColorDefinitionMap() {
        if (this.colorDefinitionMap == null) {
            this.colorDefinitionMap = new HashMap();
        }
        return this.colorDefinitionMap;
    }

    public HashMap<Integer, Object> getIdQuantityMap() {
        if (this.idQuantityMap == null) {
            this.idQuantityMap = new HashMap();
        }
        return this.idQuantityMap;
    }

    public boolean addAttribute(Integer aId, Attribute aAttribute) {
        boolean result = false;
        if (!this.getIdAttributeMap().containsKey(aId)) {
            aAttribute.setAttributeID(aId);
            if (this.getAttributes().add(aAttribute)) {
                this.getIdAttributeMap().put(aId, aAttribute);
                this.getAttributeIdMap().put(aAttribute, aId);
                result = true;
            }
        }
        return result;
    }

    public Attribute getAttribute(Integer aId) {
        return (Attribute)this.getIdAttributeMap().get(aId);
    }

    public boolean addContext(Integer aId, Context aContext) {
        boolean result = false;
        if (!this.getIdContextMap().containsKey(aId)) {
            aContext.setContextID(aId);
            if (this.getContexts().add(aContext)) {
                this.getIdContextMap().put(aId, aContext);
                this.getContextIdMap().put(aContext, aId);
                result = true;
            }
        }
        return result;
    }

    public Context getContext(Integer aId) {
        return (Context)this.getIdContextMap().get(aId);
    }

    public boolean getScaleClaimsInActivityViewWithResourceAmount() {
        return this.scaleClaimsInActivityViewWithResourceAmount;
    }

    public void setScaleClaimsInActivityViewWithResourceAmount(boolean v) {
        this.scaleClaimsInActivityViewWithResourceAmount = v;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Configuration:\n");
        result.append("   configurationVersion: " + this.configurationVersion + "\n");
        result.append("   configurationSource : " + this.configurationSource + "\n");
        result.append("   configurationName   : " + this.configurationName + "\n");
        result.append("   configurationID     : " + this.configurationID + "\n");
        result.append("   timeScaleShift      : " + this.timeScaleShift + "\n");
        result.append("   timeScaleUnit       : " + String.valueOf((Object)this.timeScaleUnit) + "\n");
        result.append("   timeDisplayFormat   : " + this.timeDisplayFormat + "\n");
        if (this.attributes == null) {
            result.append("   no attributes\n");
        } else {
            Iterator<Attribute> ia = this.attributes.iterator();
            while (ia.hasNext()) {
                result.append("   attribute: " + ia.next().toString() + "\n");
            }
        }
        if (this.contexts == null) {
            result.append("   no contexts\n");
        } else {
            for (Context cc : this.contexts) {
                result.append("   context  : " + cc.toString());
            }
        }
        return result.toString();
    }
}

