/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.product.productdata;

import java.math.BigDecimal;

import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;

public class Task {
    public final String id;

    public final BigDecimal startTime;

    public final BigDecimal endTime;

    public transient Action action;

    public final ScheduledTask<org.eclipse.lsat.common.scheduler.graph.Task> scheduledTask;

    public Task(ScheduledTask<org.eclipse.lsat.common.scheduler.graph.Task> scheduledTask, String id, BigDecimal startTime, BigDecimal endTime, Action action) {
        this.scheduledTask = scheduledTask; //scheduledTask;
        this.id = id;
        this.startTime = startTime;
        this.endTime = endTime;
        this.action = action;
    }

    public String getId() {
        return id;
    }

    public BigDecimal getStartTime() {
        return startTime;
    }

    public BigDecimal getEndTime() {
        return endTime;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public ScheduledTask<org.eclipse.lsat.common.scheduler.graph.Task> getScheduledTask() {
        return scheduledTask;
    }

    public Action getAction() {
        return action;
    }
}
