/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.automaton;

import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.automaton.MPAState;

public class MPATransition<T> {
    private final MPAState<T> source;
    private final MPAState<T> target;
    private final String event;
    private final Value duration;
    private final Value reward;

    public MPATransition(MPAState<T> source, String event, Value reward, Value duration, MPAState<T> target) {
        this.source = source;
        this.target = target;
        this.event = event;
        this.reward = reward;
        this.duration = duration;
    }

    public MPAState<T> getSource() {
        return this.source;
    }

    public MPAState<T> getTarget() {
        return this.target;
    }

    public String getEvent() {
        return this.event;
    }

    public Value getDuration() {
        return this.duration;
    }

    public Value getReward() {
        return this.reward;
    }

    public String toString() {
        return "Transition{source=" + String.valueOf(this.source) + ", target=" + String.valueOf(this.target) + ", event=" + this.event + ", duration=" + String.valueOf(this.duration) + ", reward=" + String.valueOf(this.reward) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MPATransition)) {
            return false;
        }
        MPATransition that = (MPATransition)o;
        if (!this.source.equals(that.source)) {
            return false;
        }
        if (!this.target.equals(that.target)) {
            return false;
        }
        if (!this.event.equals(that.event)) {
            return false;
        }
        if (!this.reward.equals(that.reward)) {
            return false;
        }
        return this.duration.equals(that.duration);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = 31 * result + this.target.hashCode();
        result = 31 * result + this.event.hashCode();
        result = 31 * result + this.event.hashCode();
        result = 31 * result + this.reward.hashCode();
        result = 31 * result + this.duration.hashCode();
        return result;
    }
}

