/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsat.motioncalculator.MotionProfile;
import org.eclipse.lsat.motioncalculator.MotionSegment;
import org.eclipse.lsat.motioncalculator.MotionSetPoint;
import org.eclipse.lsat.motioncalculator.MotionValidationException;

public final class MotionSegmentUtilities {
    private MotionSegmentUtilities() {
    }

    public static boolean isMotionProfile(Collection<MotionSegment> segments, String motionProfileKey) {
        return segments.stream().flatMap(s -> s.getMotionSetpoints().stream()).map(MotionSetPoint::getMotionProfile).allMatch(p -> Objects.equals(p.getKey(), motionProfileKey));
    }

    public static Set<MotionProfile> getMotionProfiles(Collection<MotionSegment> segments) {
        return segments.stream().flatMap(s -> s.getMotionSetpoints().stream()).map(MotionSetPoint::getMotionProfile).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<String> getSetPointIds(MotionSegment segment) throws MotionValidationException {
        return segment.getMotionSetpoints().stream().map(m -> m.getId()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static List<MotionSetPoint> getMotionSetPoints(List<MotionSegment> segments, String setPointId) throws MotionValidationException {
        return segments.stream().map(s -> s.getMotionSetpoint(setPointId)).collect(Collectors.toList());
    }

    public static Set<String> getSetPointIds(Collection<MotionSegment> segments) throws MotionValidationException {
        Set<String> setPointIds = MotionSegmentUtilities.getSetPointIds(segments.iterator().next());
        for (MotionSegment segment : segments) {
            if (setPointIds.equals(MotionSegmentUtilities.getSetPointIds(segment))) continue;
            throw new MotionValidationException("Programming error: A concatenated move cannot have different setpoints. Please contact LSAT support.", segment);
        }
        return setPointIds;
    }

    public static Collection<String> getMovingSetPointsIds(Collection<MotionSegment> segments) throws MotionValidationException {
        return MotionSegmentUtilities.getSetPointIds(segments).stream().filter(s -> MotionSegmentUtilities.getMotionSetPoints(segments, s).stream().anyMatch(MotionSetPoint::doesMove)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<String> getSettledSetPointIds(Collection<MotionSegment> segments) throws MotionValidationException {
        return segments.stream().reduce((first, second) -> second).get().getMotionSetpoints().stream().filter(MotionSetPoint::isSettling).map(MotionSetPoint::getId).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static List<MotionSetPoint> getMotionSetPoints(Collection<MotionSegment> segments, String setPointId) {
        return segments.stream().map(s -> s.getMotionSetpoint(setPointId)).toList();
    }

    public static List<MotionSetPoint> getMovingMotionSetPoints(Collection<MotionSegment> segments) {
        return segments.stream().flatMap(s -> s.getMotionSetpoints().stream()).filter(MotionSetPoint::doesMove).toList();
    }

    private static double toPositiveDouble(BigDecimal bd) {
        if (bd == null) {
            return 0.0;
        }
        return Math.abs(bd.doubleValue());
    }

    public static List<Double> getMotionMaxima(Collection<MotionSegment> segments, String setPointId, String key) {
        return segments.stream().map(s -> MotionSegmentUtilities.toPositiveDouble(s.getMotionSetpoint(setPointId).getMotionProfileArgument(key))).toList();
    }
}

