/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.mpt.api.adapter;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.FSMImpl;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.mpt.Edge;
import org.eclipse.lsat.common.mpt.FSM;
import org.eclipse.lsat.common.mpt.FSMState;
import org.eclipse.lsat.common.mpt.FSMTransition;
import org.eclipse.lsat.common.mpt.MaxPlusSpecification;
import org.eclipse.lsat.common.mpt.Vertex;
import org.eclipse.lsat.common.mpt.api.MaxPlusException;

public class FSMAdapter {
    private FSMAdapter() {
    }

    public static FSMImpl getFSM(MaxPlusSpecification specification, FSM mptFSM) throws MaxPlusException {
        Set uncontrollable = specification.getUncontrollable().stream().map(event -> event.getName()).collect(Collectors.toSet());
        FSMImpl fsmImpl = new FSMImpl();
        for (Vertex v : mptFSM.getVertices()) {
            FSMState s = (FSMState)v;
            if (s.getName() == null || s.getName().isEmpty()) {
                throw new MaxPlusException("Automaton " + mptFSM.getName() + " has a location without name. This is not supported.");
            }
            Location location = new Location(s.getName());
            fsmImpl.addLocation(location);
            if (!s.isMarked()) continue;
            fsmImpl.setMarked(location);
        }
        fsmImpl.setInitial(fsmImpl.getLocation(mptFSM.getInitial().getName()));
        for (Edge e : mptFSM.getEdges()) {
            Location src = fsmImpl.getLocation(((FSMState)e.getSource()).getName());
            Location tgt = fsmImpl.getLocation(((FSMState)e.getTarget()).getName());
            String event2 = ((FSMTransition)e).getName();
            fsmImpl.addEdge(src, tgt, event2);
            if (uncontrollable.contains(event2)) {
                fsmImpl.addUncontrollable(event2);
                continue;
            }
            fsmImpl.addControllable(event2);
        }
        return fsmImpl;
    }
}

