/**
 */
package common.util;

import common.*;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see common.CommonPackage
 * @generated
 */
public class CommonSwitch<T> extends Switch<T>
{
    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static CommonPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public CommonSwitch()
    {
        if (modelPackage == null)
        {
            modelPackage = CommonPackage.eINSTANCE;
        }
    }

    /**
     * Checks whether this is a switch for the given package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
    @Override
    protected boolean isSwitchFor(EPackage ePackage)
    {
        return ePackage == modelPackage;
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    @Override
    protected T doSwitch(int classifierID, EObject theEObject)
    {
        switch (classifierID)
        {
            case CommonPackage.IMPORT_CONTAINER:
            {
                ImportContainer importContainer = (ImportContainer)theEObject;
                T result = caseImportContainer(importContainer);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case CommonPackage.IMPORT:
            {
                Import import_ = (Import)theEObject;
                T result = caseImport(import_);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case CommonPackage.HAS_PARAMETERS:
            {
                HasParameters hasParameters = (HasParameters)theEObject;
                T result = caseHasParameters(hasParameters);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case CommonPackage.HAS_PARAMETER_DECLARATIONS:
            {
                HasParameterDeclarations hasParameterDeclarations = (HasParameterDeclarations)theEObject;
                T result = caseHasParameterDeclarations(hasParameterDeclarations);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case CommonPackage.PARAMETER_DECLARATION:
            {
                ParameterDeclaration parameterDeclaration = (ParameterDeclaration)theEObject;
                T result = caseParameterDeclaration(parameterDeclaration);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case CommonPackage.TYPE_DEFINITION:
            {
                TypeDefinition typeDefinition = (TypeDefinition)theEObject;
                T result = caseTypeDefinition(typeDefinition);
                if (result == null) result = caseHasName(typeDefinition);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case CommonPackage.PARAMETER:
            {
                Parameter parameter = (Parameter)theEObject;
                T result = caseParameter(parameter);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case CommonPackage.HAS_NAME:
            {
                HasName hasName = (HasName)theEObject;
                T result = caseHasName(hasName);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case CommonPackage.PARAMETER_REFERENCE:
            {
                ParameterReference parameterReference = (ParameterReference)theEObject;
                T result = caseParameterReference(parameterReference);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Import Container</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Import Container</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseImportContainer(ImportContainer object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Import</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Import</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseImport(Import object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Has Parameters</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Has Parameters</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseHasParameters(HasParameters object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Has Parameter Declarations</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Has Parameter Declarations</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseHasParameterDeclarations(HasParameterDeclarations object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Parameter Declaration</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Parameter Declaration</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseParameterDeclaration(ParameterDeclaration object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Type Definition</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Type Definition</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseTypeDefinition(TypeDefinition object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Parameter</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Parameter</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseParameter(Parameter object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Has Name</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Has Name</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseHasName(HasName object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Parameter Reference</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Parameter Reference</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseParameterReference(ParameterReference object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    @Override
    public T defaultCase(EObject object)
    {
        return null;
    }

} //CommonSwitch
