/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.view;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.view.AbstractEdgeLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;

public class EdgeLabelLayoutData
extends AbstractEdgeLayoutData {
    private Point labelLocation;
    private Rectangle labelBounds;

    public EdgeLabelLayoutData(LayoutData parent, DEdge target, Edge gmfEdge) {
        super(parent, target, gmfEdge);
    }

    @Override
    protected void init(Edge gmfEdge) {
        Node labelNode = SiriusGMFHelper.getLabelNode((View)gmfEdge);
        if (labelNode != null && labelNode.getLayoutConstraint() instanceof Bounds) {
            Bounds oldLabelBounds = (Bounds)labelNode.getLayoutConstraint();
            this.labelLocation = new Point(oldLabelBounds.getX(), oldLabelBounds.getY());
            this.labelBounds = new Rectangle(oldLabelBounds.getX(), oldLabelBounds.getY(), oldLabelBounds.getWidth(), oldLabelBounds.getHeight());
        } else if (labelNode != null && labelNode.getLayoutConstraint() instanceof Location) {
            Location oldLabelLocation = (Location)labelNode.getLayoutConstraint();
            this.labelLocation = new Point(oldLabelLocation.getX(), oldLabelLocation.getY());
        }
    }

    public EdgeLabelLayoutData getData(DEdge edge, boolean ignoreConsumeState) {
        return (ignoreConsumeState || !this.isConsume()) && this.getTarget().equals(edge) ? this : null;
    }

    public Point getLocation() {
        return this.labelLocation;
    }

    public Rectangle getLabelBounds() {
        return this.labelBounds;
    }
}

