/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.UnwrapNewArrayOperation;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class UnnecessaryArrayCreationFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private final IStatus fStatus;

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean removeUnnecessaryArrayCreation) {
        if (!JavaModelUtil.is50OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        if (!removeUnnecessaryArrayCreation) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        UnnecessaryArrayCreationFinder finder = new UnnecessaryArrayCreationFinder(removeUnnecessaryArrayCreation, operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[operations.size()]);
        return new ConvertLoopFixCore(FixMessages.ControlStatementsFix_change_name, compilationUnit, ops, null);
    }

    public static UnnecessaryArrayCreationFixCore createUnnecessaryArrayCreationFix(CompilationUnit compilationUnit, Expression methodInvocation) {
        if (!JavaModelUtil.is50OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        UnnecessaryArrayCreationFinder finder = new UnnecessaryArrayCreationFinder(true, operations);
        methodInvocation.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        return new UnnecessaryArrayCreationFixCore(FixMessages.Java50Fix_RemoveUnnecessaryArrayCreation_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{(CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation)operations.get(0)}, null);
    }

    protected UnnecessaryArrayCreationFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations, IStatus status) {
        super(name, compilationUnit, fixRewriteOperations);
        this.fStatus = status;
    }

    @Override
    public IStatus getStatus() {
        return this.fStatus;
    }

    public static final class UnnecessaryArrayCreationFinder
    extends GenericVisitor {
        private static final Set<String> fInvalidTypes = new HashSet<String>(Arrays.asList("byte", "char", "short"));
        private final List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;
        private final boolean fRemoveUnnecessaryArrayCreation;

        public UnnecessaryArrayCreationFinder(boolean removeUnnecessaryArrayCreation, List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> resultingCollection) {
            this.fRemoveUnnecessaryArrayCreation = removeUnnecessaryArrayCreation;
            this.fResult = resultingCollection;
        }

        @Override
        public boolean visit(ArrayCreation visited) {
            SuperMethodInvocation sm;
            ASTNode parent;
            if (!this.fRemoveUnnecessaryArrayCreation || visited.getType().getDimensions() != 1) {
                return true;
            }
            ArrayInitializer initializer = visited.getInitializer();
            if (initializer != null && initializer.expressions() != null && initializer.expressions().size() == 1) {
                List expressions = initializer.expressions();
                ITypeBinding singleElement = ((Expression)expressions.get(0)).resolveTypeBinding();
                if (ASTNodes.is((Expression)expressions.get(0), NullLiteral.class) || singleElement == null || singleElement.isArray()) {
                    return true;
                }
            }
            if ((parent = visited.getParent()) instanceof ClassInstanceCreation && visited.getLocationInParent() == ClassInstanceCreation.ARGUMENTS_PROPERTY) {
                ClassInstanceCreation cic = (ClassInstanceCreation)parent;
                if (this.canArrayBeRemoved(visited, cic.arguments(), cic.resolveConstructorBinding())) {
                    this.fResult.add(new UnwrapNewArrayOperation(visited, (Expression)cic));
                }
            } else if (parent instanceof MethodInvocation && visited.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY) {
                MethodInvocation m = (MethodInvocation)parent;
                if (this.canArrayBeRemoved(visited, m.arguments(), m.resolveMethodBinding())) {
                    this.fResult.add(new UnwrapNewArrayOperation(visited, (Expression)m));
                }
            } else if (parent instanceof SuperMethodInvocation && visited.getLocationInParent() == SuperMethodInvocation.ARGUMENTS_PROPERTY && this.canArrayBeRemoved(visited, (sm = (SuperMethodInvocation)parent).arguments(), sm.resolveMethodBinding())) {
                this.fResult.add(new UnwrapNewArrayOperation(visited, (Expression)sm));
            }
            return true;
        }

        private boolean canArrayBeRemoved(ArrayCreation visited, List<Expression> arguments, IMethodBinding binding) {
            return this.isUselessArrayCreation(visited, arguments, binding) && !ASTNodes.hasConflictingMethodOrConstructor(visited.getParent(), binding, this.getParameterTypesForConflictingMethod(arguments, visited));
        }

        private boolean isUselessArrayCreation(ArrayCreation visited, List<Expression> arguments, IMethodBinding binding) {
            return (visited.getInitializer() != null || visited.dimensions().size() == 1 && Long.valueOf(0L).equals(ASTNodes.getIntegerLiteral((Expression)visited.dimensions().get(0)))) && !arguments.isEmpty() && arguments.get(arguments.size() - 1) == visited && binding != null && binding.isVarargs() && binding.getParameterTypes().length == arguments.size() && binding.getParameterTypes()[arguments.size() - 1].getDimensions() == 1 && !fInvalidTypes.contains(binding.getParameterTypes()[arguments.size() - 1].getElementType().getName());
        }

        private ITypeBinding[] getParameterTypesForConflictingMethod(List<Expression> arguments, ArrayCreation visited) {
            ArrayInitializer initializer = visited.getInitializer();
            List initializerExpressions = initializer != null ? initializer.expressions() : Collections.EMPTY_LIST;
            return (ITypeBinding[])Stream.concat(arguments.stream().limit(arguments.size() - 1), initializerExpressions.stream()).map(Expression::resolveTypeBinding).toArray(ITypeBinding[]::new);
        }
    }
}

