/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.util.TypeUtil;

public class IntermediatePropertyHierarchy {
    private QvtOperationalEnv fEnv;
    private Map<String, List<Entry>> fData;

    public IntermediatePropertyHierarchy(Module module, QvtOperationalEnv env) {
        if (env == null) {
            throw new IllegalArgumentException();
        }
        this.fEnv = env;
        this.readHierarchy(module);
    }

    public boolean hasHierarchyClashes(ContextualProperty property) {
        if (this.fData == null || this.fData.isEmpty()) {
            return false;
        }
        List<Entry> entryList = this.fData.get(property.getName());
        if (entryList == null) {
            return false;
        }
        for (Entry entry : entryList) {
            Boolean status = entry.isClashingWith(property);
            if (!Boolean.TRUE.equals(status)) continue;
            return true;
        }
        return false;
    }

    private Map<String, List<Entry>> getData() {
        if (this.fData == null) {
            this.fData = new HashMap<String, List<Entry>>();
        }
        return this.fData;
    }

    private void readHierarchy(Module module) {
        for (ModuleImport moduleImport : module.getModuleImport()) {
            Module importedModule = moduleImport.getImportedModule();
            if (importedModule == null) continue;
            this.readHierarchy(importedModule);
        }
        for (EStructuralFeature nextFeature : module.getEAllStructuralFeatures()) {
            ContextualProperty ctxProp;
            if (!(nextFeature instanceof ContextualProperty) || (ctxProp = (ContextualProperty)nextFeature).getContext() == null) continue;
            String name = ctxProp.getName();
            List<Entry> entryList = this.getData().get(name);
            if (entryList == null) {
                entryList = new LinkedList<Entry>();
                this.getData().put(name, entryList);
            }
            boolean joined = false;
            for (Entry entry : entryList) {
                if (!entry.addIfApplicable(ctxProp)) continue;
                joined = true;
                break;
            }
            if (joined) continue;
            Entry newEntry = new Entry();
            entryList.add(newEntry);
            newEntry.addIfApplicable(ctxProp);
        }
    }

    private boolean isPartOfHierarchy(ContextualProperty c1, ContextualProperty c2) {
        if (c1.getContext() != null && c2.getContext() != null) {
            int rel = TypeUtil.getRelationship((Environment)this.fEnv, (Object)c1.getContext(), (Object)c2.getContext());
            return (rel & 7) != 0;
        }
        return false;
    }

    private class Entry {
        private List<ContextualProperty> hierarchy;

        private Entry() {
        }

        boolean addIfApplicable(ContextualProperty property) {
            if (this.hierarchy == null) {
                this.hierarchy = new LinkedList<ContextualProperty>();
                this.hierarchy.add(property);
                return true;
            }
            for (ContextualProperty contextualProperty : this.hierarchy) {
                if (property == contextualProperty || !IntermediatePropertyHierarchy.this.isPartOfHierarchy(contextualProperty, property)) continue;
                this.hierarchy.add(property);
                return false;
            }
            return false;
        }

        Boolean isClashingWith(ContextualProperty property) {
            if (this.hierarchy == null || this.hierarchy.isEmpty() || !this.hierarchy.contains(property)) {
                return null;
            }
            return this.hierarchy.size() > 1 ? Boolean.TRUE : Boolean.FALSE;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            if (this.hierarchy != null) {
                for (ContextualProperty prop : this.hierarchy) {
                    if (prop.getContext() != null) {
                        buf.append(prop.getContext().getName());
                    }
                    buf.append(',');
                }
            }
            buf.append(']');
            return buf.toString();
        }
    }
}

