/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.internal.actions.session.CloseSessionsAction;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenSessionAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class OpenCloseSessionAction
extends SelectionListenerAction {
    private boolean open = true;
    private final String openText;
    private final String closeText;
    private final SelectionListenerAction openSessionAction;
    private final SelectionListenerAction closeSessionAction;

    public OpenCloseSessionAction(String openText, String closeText) {
        super(openText);
        this.openText = openText;
        this.closeText = closeText;
        this.openSessionAction = new OpenSessionAction(openText);
        this.closeSessionAction = new CloseSessionsAction(closeText);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        List<IFile> selectedFiles = this.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.size() != 1 || ModelingProject.hasModelingProjectNature((IProject)selectedFiles.iterator().next().getProject())) {
            return false;
        }
        List<Session> openedSession = this.getSelectedOpenedSessions(selectedFiles);
        this.openSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection(selectedFiles));
        this.closeSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection(openedSession));
        this.open = true;
        this.setText(this.openText);
        if (!openedSession.isEmpty()) {
            this.open = false;
            this.setText(this.closeText);
        }
        return super.updateSelection(selection) && this.selectionIsOfType(1);
    }

    public void run() {
        if (this.open) {
            this.openSessionAction.run();
        } else {
            this.closeSessionAction.run();
        }
    }

    private List<IFile> getSelectedFiles() {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.getSelectedResources(), IFile.class));
    }

    private List<Session> getSelectedOpenedSessions(Collection<IFile> selectedFiles) {
        HashSet<URI> selectedUris = new HashSet<URI>();
        for (IFile selectedFile : selectedFiles) {
            if (!"aird".equals(selectedFile.getFileExtension())) continue;
            selectedUris.add(URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true));
        }
        HashSet<Session> openedSession = new HashSet<Session>();
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            if (!session.isOpen()) continue;
            for (Resource res : session.getAllSessionResources()) {
                if (!selectedUris.contains(res.getURI())) continue;
                openedSession.add(session);
            }
        }
        return Lists.newArrayList(openedSession);
    }

    public boolean isOpenMode() {
        return this.open;
    }
}

