/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.util;

import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public final class ElkUiUtil {
    private ElkUiUtil() {
    }

    public static void runModelChange(final Runnable runnable, EditingDomain editingDomain, String label) {
        if (editingDomain instanceof TransactionalEditingDomain) {
            editingDomain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)editingDomain, label){

                protected void doExecute() {
                    runnable.run();
                }
            });
        } else if (editingDomain != null) {
            editingDomain.getCommandStack().execute((Command)new AbstractCommand(label){

                public void execute() {
                    runnable.run();
                }

                public boolean canUndo() {
                    return false;
                }

                public void redo() {
                    this.execute();
                }
            });
        } else {
            runnable.run();
        }
    }

    public static LayoutOptionData getOptionData(LayoutAlgorithmData providerData, String optionName) {
        for (LayoutOptionData data : LayoutMetaDataService.getInstance().getOptionData()) {
            if (!data.getName().equals(optionName) || !providerData.knowsOption(data)) continue;
            return data;
        }
        return null;
    }

    public static LayoutOptionData getOptionData(LayoutAlgorithmData[] providerDataArray, String displayName) {
        LayoutAlgorithmData[] layoutAlgorithmDataArray = providerDataArray;
        int n = providerDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutAlgorithmData providerData = layoutAlgorithmDataArray[n2];
            LayoutOptionData optionData = ElkUiUtil.getOptionData(providerData, displayName);
            if (optionData != null) {
                return optionData;
            }
            ++n2;
        }
        return LayoutMetaDataService.getInstance().getOptionData(CoreOptions.ALGORITHM.getId());
    }
}

