/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.common.mpt.api;

import java.util.List;

public class MinimumThroughputResult {
    private final double throughput;

    private final List<String> activities;

    public MinimumThroughputResult(double throughput, List<String> activities) {
        this.throughput = throughput;
        this.activities = activities;
    }

    public double getThroughput() {
        return throughput;
    }

    public List<String> getActivities() {
        return activities;
    }

    @Override
    public String toString() {
        return "MinimumThroughputResult [throughput=" + throughput + ", activities=" + activities + "]";
    }
}
