/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts;

import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.AbstractChartWithAxisBuilder;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.BarChart;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners.BarChartMouseMoveListener;
import org.eclipse.linuxtools.systemtap.graphing.core.adapters.IAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.Range;

public class BarChartBuilder
extends AbstractChartWithAxisBuilder {
    public static final String ID = "org.eclipse.linuxtools.systemtap.graphing.ui.charts.barchartbuilder";

    public BarChartBuilder(Composite parent, int style, String title, IAdapter adapter) {
        super(adapter, parent, style, title);
    }

    @Override
    protected double getChartMarginYL() {
        return 0.0;
    }

    @Override
    protected void createChart() {
        this.chart = new BarChart(this, this.getStyle());
        this.applyTitleBoundsListener();
        this.chartMouseMoveListener = new BarChartMouseMoveListener((BarChart)this.chart, this.chart.getPlotArea().getControl());
    }

    @Override
    protected ISeries<?> createChartISeries(int i) {
        IBarSeries series = (IBarSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.BAR, this.adapter.getLabels()[i + 1]);
        series.setBarColor(COLORS[i % COLORS.length]);
        return series;
    }

    @Override
    protected void buildXSeries() {
        Object[][] data = this.adapter.getData();
        if (data == null || data.length == 0) {
            return;
        }
        int start = 0;
        int len = Math.min(this.maxItems, data.length);
        int leny = data[0].length - 1;
        if (this.maxItems < data.length) {
            start = data.length - this.maxItems;
        }
        String[] allValx = new String[len];
        Double[][] allValy = new Double[leny][len];
        double maxY = 0.0;
        double minY = 0.0;
        for (int i = 0; i < len; ++i) {
            Object label = data[start + i][0];
            if (label == null) continue;
            allValx[i] = label.toString();
            for (int j = 1; j < leny + 1; ++j) {
                Double val = this.getDoubleOrNullValue(data[start + i][j]);
                if (val == null) {
                    val = 0.0;
                }
                allValy[j - 1][i] = val;
                maxY = Math.max(val, maxY);
                minY = Math.min(val, minY);
            }
        }
        String[] valx = new String[len];
        int lenTrim = 0;
        for (int i = 0; i < len; ++i) {
            if (allValx[i] == null) continue;
            valx[lenTrim] = allValx[i];
            ++lenTrim;
        }
        String[] valxTrim = new String[lenTrim];
        System.arraycopy(valx, 0, valxTrim, 0, lenTrim);
        ISeries[] allSeries = this.chart.getSeriesSet().getSeries();
        for (int i = 0; i < leny; ++i) {
            ISeries series = i >= allSeries.length ? this.createChartISeries(i) : this.chart.getSeriesSet().getSeries()[i];
            double[] valy = new double[len];
            int lenyTrim = 0;
            for (int j = 0; j < len; ++j) {
                if (allValy[i][j] == null) continue;
                valy[lenyTrim] = allValy[i][j];
                ++lenyTrim;
            }
            double[] valyTrim = new double[lenyTrim];
            System.arraycopy(valy, 0, valyTrim, 0, lenyTrim);
            series.setYSeries(valyTrim);
        }
        ((BarChart)this.chart).suspendUpdate(true);
        ((BarChart)this.chart).setCategorySeries(this.getUniqueNames(valxTrim));
        this.applyCategoryRange(valxTrim.length);
        this.applyRangeY(minY, maxY);
        ((BarChart)this.chart).suspendUpdate(false);
        this.chart.redraw();
    }

    private void applyCategoryRange(int numItems) {
        int itemRange = Math.max(1, (int)Math.ceil((double)numItems * this.scale));
        int lower = (int)Math.round((double)(numItems - itemRange) * this.scroll);
        this.chart.getAxisSet().getXAxis(0).setRange(new Range((double)lower, (double)(lower + itemRange - 1)));
    }

    @Override
    public void updateDataSet() {
        this.buildXSeries();
        this.chartMouseMoveListener.update();
    }
}

