/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImageRemoveTagPage
extends WizardPage {
    private static final String NAME = "ImageRemoveTag.name";
    private static final String TITLE = "ImageRemoveTag.title";
    private static final String DESC = "ImageRemoveTag.desc";
    private static final String REMOVE_TAG_LABEL = "ImageRemoveTagName.label";
    private static final String REMOVE_TAG_TOOLTIP = "ImageRemoveTagName.toolTip";
    private String selectedTag;
    private IDockerImage image;

    public ImageRemoveTagPage(IDockerImage image) {
        super(WizardMessages.getString(NAME));
        this.setDescription(WizardMessages.getString(DESC));
        this.setTitle(WizardMessages.getString(TITLE));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
        this.image = image;
    }

    public String getTag() {
        return this.selectedTag;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)container);
        Label repoLabel = new Label(container, 0);
        repoLabel.setText(WizardMessages.getString(REMOVE_TAG_LABEL));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)repoLabel);
        Combo tagCombo = new Combo(container, 2056);
        tagCombo.setToolTipText(WizardMessages.getString(REMOVE_TAG_TOOLTIP));
        tagCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.selectedTag = tagCombo.getText();
        }));
        List repoTags = this.image.repoTags();
        tagCombo.setItems(repoTags.toArray(new String[0]));
        tagCombo.select(0);
        this.selectedTag = tagCombo.getItem(0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)tagCombo);
        this.setControl((Control)container);
    }
}

