/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.parser;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.linuxtools.internal.gprof.parser.CallGraphDecoder;
import org.eclipse.linuxtools.internal.gprof.parser.CallGraphDecoder64;
import org.eclipse.linuxtools.internal.gprof.parser.HistogramDecoder;
import org.eclipse.linuxtools.internal.gprof.parser.HistogramDecoder64;
import org.eclipse.linuxtools.internal.gprof.utils.LEDataInputStream;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistRoot;

public class GmonDecoder {
    public static final int VPF_GMON_RECORD_TYPE_HISTOGRAM = 0;
    public static final int VPF_GMON_RECORD_TYPE_CALLGRAPH = 1;
    public static final int VPF_GMON_RECORD_TYPE_UNKNOWN = -1;
    public static final int GMONVERSION = 333945;
    private String cookie;
    private int gmonVersion;
    private final IBinaryParser.IBinaryObject program;
    final boolean _32_bit_platform;
    private HistogramDecoder histo;
    private CallGraphDecoder callGraph;
    private final PrintStream ps;
    private final HistRoot rootNode = new HistRoot(this);
    private String file;
    private int tag = -1;
    private final HashMap<IBinaryParser.ISymbol, String> filenames = new HashMap();
    private final IProject project;
    private boolean shouldDump = false;

    public GmonDecoder(IBinaryParser.IBinaryObject program, IProject project) {
        this(program, null, project);
    }

    public GmonDecoder(IBinaryParser.IBinaryObject program, PrintStream ps, IProject project) {
        this.program = program;
        this.ps = ps;
        this.project = project;
        program.getBinaryParser().getFormat();
        IAddressFactory factory = program.getAddressFactory();
        int addrSize = 4;
        if (factory != null) {
            addrSize = factory.getMax().getSize();
        }
        String cpu = program.getCPU();
        if (addrSize > 4 || cpu.endsWith("64")) {
            this.histo = new HistogramDecoder64(this);
            this.callGraph = new CallGraphDecoder64(this);
            this._32_bit_platform = false;
        } else {
            this._32_bit_platform = true;
            this.histo = new HistogramDecoder(this);
            this.callGraph = new CallGraphDecoder(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String file) throws IOException {
        block18: {
            this.file = file;
            DataInputStream beStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            if (this.program.isLittleEndian()) {
                try (LEDataInputStream leStream = new LEDataInputStream(beStream);){
                    leStream.mark(1000);
                    boolean gmonType = this.readHeader(leStream);
                    if (gmonType) {
                        this.readGmonContent(leStream);
                    }
                    leStream.reset();
                    this.histo.decodeOldHeader(leStream);
                    this.histo.decodeHistRecord(leStream);
                    try {
                        while (true) {
                            this.callGraph.decodeCallGraphRecord(leStream, true);
                        }
                    }
                    catch (EOFException eOFException) {
                        this.callGraph.populate(this.rootNode);
                        this.histo.assignSamplesSymbol();
                    }
                }
            } else {
                try {
                    beStream.mark(1000);
                    boolean gmonType = this.readHeader(beStream);
                    if (gmonType) {
                        this.readGmonContent(beStream);
                        break block18;
                    }
                    beStream.reset();
                    this.histo.decodeOldHeader(beStream);
                    this.histo.decodeHistRecord(beStream);
                    try {
                        while (true) {
                            this.callGraph.decodeCallGraphRecord(beStream, true);
                        }
                    }
                    catch (EOFException eOFException) {
                        this.callGraph.populate(this.rootNode);
                        this.histo.assignSamplesSymbol();
                    }
                }
                finally {
                    beStream.close();
                }
            }
        }
    }

    private boolean readHeader(DataInput stream) throws IOException {
        byte[] _cookie = new byte[4];
        stream.readFully(_cookie);
        this.cookie = new String(_cookie);
        this.gmonVersion = stream.readInt();
        byte[] spare = new byte[12];
        stream.readFully(spare);
        return "gmon".equals(this.cookie);
    }

    private void readGmonContent(DataInput stream) throws IOException {
        while (true) {
            this.tag = -1;
            try {
                this.tag = stream.readByte();
            }
            catch (EOFException e) {
                break;
            }
            switch (this.tag) {
                case 0: {
                    this.histo.decodeHeader(stream);
                    this.histo.decodeHistRecord(stream);
                    break;
                }
                case 1: {
                    this.callGraph.decodeCallGraphRecord(stream, false);
                    break;
                }
                default: {
                    throw new IOException(Messages.GmonDecoder_BAD_TAG_ERROR);
                }
            }
            if (!this.shouldDump) continue;
            this.dumpGmonResult(this.ps == null ? System.out : this.ps);
        }
        this.callGraph.populate(this.rootNode);
        this.histo.assignSamplesSymbol();
    }

    public void dumpGmonResult(PrintStream ps) {
        ps.println("-- gmon Results --");
        ps.println("cookie " + this.cookie);
        ps.println("gmon_version " + this.gmonVersion);
        ps.println("tag " + this.tag);
        switch (this.tag) {
            case 0: {
                this.histo.printHistHeader(ps);
                this.histo.printHistRecords(ps);
                break;
            }
        }
    }

    public HistogramDecoder getHistogramDecoder() {
        return this.histo;
    }

    public IBinaryParser.IBinaryObject getProgram() {
        return this.program;
    }

    public HistRoot getRootNode() {
        return this.rootNode;
    }

    public String getGmonFile() {
        return this.file;
    }

    public String getGmonFileTimeStamp() {
        return DateFormat.getInstance().format(new Date(new File(this.file).lastModified()));
    }

    public String getFileName(IBinaryParser.ISymbol s) {
        String ret = this.filenames.get(s);
        if (ret == null) {
            ret = STSymbolManager.sharedInstance.getFilename(s, this.project);
            if (ret == null) {
                ret = "??";
            }
            this.filenames.put(s, ret);
        }
        return ret;
    }

    public void setShouldDump(boolean shouldDump) {
        this.shouldDump = shouldDump;
    }

    public IProject getProject() {
        return this.project;
    }
}

