/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.linuxtools.internal.callgraph.core.CallgraphCorePlugin;
import org.eclipse.linuxtools.internal.callgraph.core.Messages;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapParser;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public abstract class SystemTapView
extends ViewPart {
    private final String NEW_LINE = Messages.getString("SystemTapView.1");
    public Composite masterComposite;
    private Action kill;
    protected String viewID;
    private Action helpVersion;
    protected Action saveFile;
    protected Action openFile;
    protected Action openDefault;
    protected String sourcePath;
    protected IMenuManager file;
    private SystemTapParser parser;

    public abstract IStatus initializeView(Display var1, IProgressMonitor var2);

    public void layout() {
        this.masterComposite.layout();
    }

    public void maximizeIfUnmaximized() {
        IWorkbenchPage page = this.getViewSite().getWorkbenchWindow().getActivePage();
        if (page.getPartState(page.getActivePartReference()) != 1) {
            IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
            try {
                handlerService.executeCommand("org.eclipse.ui.window.maximizePart", null);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                e.printStackTrace();
            }
        }
    }

    public void update() throws InterruptedException {
        ViewUIUpdater updater = new ViewUIUpdater("SystemTapView.update");
        updater.schedule();
        updater.join();
    }

    public SystemTapParser getParser() {
        return this.parser;
    }

    public boolean setParser(SystemTapParser parser) {
        this.parser = parser;
        return this.parser != null;
    }

    public abstract void updateMethod();

    public abstract void setViewID();

    protected abstract boolean createOpenAction();

    protected abstract boolean createOpenDefaultAction();

    public void addFileMenu() {
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        if (this.file == null) {
            this.file = new MenuManager(Messages.getString("SystemTapView.FileMenu"));
            menu.add((IContributionItem)this.file);
        }
        if (this.createOpenAction()) {
            this.file.add((IAction)this.openFile);
        }
        if (this.createOpenDefaultAction()) {
            this.file.add((IAction)this.openDefault);
        }
        this.createSaveAction();
        this.file.add((IAction)this.saveFile);
    }

    public void addHelpMenu() {
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        MenuManager help = new MenuManager(Messages.getString("SystemTapView.Help"));
        menu.add((IContributionItem)help);
        this.createHelpActions();
        help.add((IAction)this.helpVersion);
    }

    private void createHelpActions() {
        this.helpVersion = new Action(Messages.getString("SystemTapView.Version")){

            public void run() {
                try {
                    Process pr = RuntimeProcessFactory.getFactory().exec("stap -V", null);
                    BufferedReader buf = pr.errorReader();
                    String line = "";
                    Object message = "";
                    while ((line = buf.readLine()) != null) {
                        message = (String)message + line + SystemTapView.this.NEW_LINE;
                    }
                    try {
                        pr.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Shell sh = new Shell();
                    MessageDialog.openInformation((Shell)sh, (String)Messages.getString("SystemTapView.StapVersion"), (String)message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private void createSaveAction() {
        this.saveFile = new Action(Messages.getString("SystemTapView.SaveMenu")){

            public void run() {
                Shell sh = new Shell();
                FileDialog dialog = new FileDialog(sh, 8192);
                String filePath = dialog.open();
                if (filePath != null) {
                    SystemTapView.this.saveData(filePath);
                }
            }
        };
    }

    protected void addKillButton() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.kill = new Action(Messages.getString("SystemTapView.StopScript"), (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.linuxtools.callgraph.core", (String)"icons/progress_stop.gif").get()){

            public void run() {
                SystemTapView.this.getParser().cancelJob();
            }
        };
        mgr.add((IAction)this.kill);
        this.setKillButtonEnabled(false);
    }

    public void setKillButtonEnabled(boolean val) {
        if (this.kill != null) {
            this.kill.setEnabled(val);
        }
    }

    public void saveData(String targetFile) {
        try {
            File file = new File(targetFile);
            file.delete();
            file.createNewFile();
            File sFile = new File(this.sourcePath);
            if (!sFile.exists()) {
                return;
            }
            try (FileInputStream fileIn = new FileInputStream(sFile);
                 FileOutputStream fileOut = new FileOutputStream(file);
                 FileChannel channelIn = fileIn.getChannel();
                 FileChannel channelOut = fileOut.getChannel();){
                if (channelIn == null || channelOut == null) {
                    return;
                }
                long size = channelIn.size();
                MappedByteBuffer buf = channelIn.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                channelOut.write(buf);
            }
        }
        catch (IOException e) {
            CallgraphCorePlugin.logException(e);
        }
    }

    public void setSourcePath(String file) {
        this.sourcePath = file;
    }

    private class ViewUIUpdater
    extends UIJob {
        public ViewUIUpdater(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SystemTapView.this.updateMethod();
            return Status.OK_STATUS;
        }
    }
}

