/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.request.handler.jaxrs;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.request.handler.jaxrs.consumer.RequestArgumentHandler;
import org.eclipse.kura.request.handler.jaxrs.consumer.RequestParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestParameterHandlers {
    private static final Logger logger = LoggerFactory.getLogger(RequestParameterHandlers.class);
    private static final Object[] EMPTY_PARAMETERS = new Object[0];

    private RequestParameterHandlers() {
    }

    public static RequestParameterHandler noArgsHandler() {
        return m -> EMPTY_PARAMETERS;
    }

    public static RequestParameterHandler fromArgumentHandlers(List<RequestArgumentHandler<?>> handlers) {
        return m -> {
            Object[] result = new Object[handlers.size()];
            int i = 0;
            while (i < handlers.size()) {
                result[i] = ((RequestArgumentHandler)handlers.get(i)).buildParameter(m);
                ++i;
            }
            return result;
        };
    }

    public static <T> RequestArgumentHandler<T> nullArgumentHandler() {
        return m -> null;
    }

    public static RequestArgumentHandler<InputStream> inputStreamArgumentHandler() {
        return m -> {
            KuraPayload payload = m.getPayload();
            byte[] body = payload.getBody();
            if (body == null || body.length == 0) {
                return null;
            }
            return new ByteArrayInputStream(body);
        };
    }

    public static RequestParameterHandler inputStreamHandler() {
        return m -> {
            RequestArgumentHandler<InputStream> handler = RequestParameterHandlers.inputStreamArgumentHandler();
            return new Object[]{handler.buildParameter(m)};
        };
    }

    public static <T> RequestArgumentHandler<T> gsonArgumentHandler(Class<T> type, Gson gson) {
        return m -> {
            Object result;
            String asString;
            KuraPayload payload = m.getPayload();
            byte[] body = payload.getBody();
            if (body == null || body.length == 0) {
                return null;
            }
            try {
                asString = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(body)).toString();
            }
            catch (Exception e) {
                logger.warn("request body is not valid UTF8", (Throwable)e);
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
            }
            try {
                result = gson.fromJson(asString, type);
            }
            catch (Exception e) {
                logger.warn("malformed JSON request", (Throwable)e);
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
            }
            return result;
        };
    }

    public static RequestParameterHandler gsonHandler(Class<?> type, Gson gson) {
        return m -> {
            RequestArgumentHandler handler = RequestParameterHandlers.gsonArgumentHandler(type, gson);
            return new Object[]{handler.buildParameter(m)};
        };
    }
}

