/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.text;

import junit.framework.TestCase;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.text.DocumentChange;
import org.eclipse.handly.text.DocumentChangeOperation;
import org.eclipse.handly.text.IDocumentChange;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class DocumentChangeOperationTest
extends TestCase {
    private IDocument document;

    protected void setUp() throws Exception {
        super.setUp();
        this.document = new Document();
    }

    public void test1() throws Exception {
        DocumentChange change = new DocumentChange((TextEdit)new InsertEdit(0, "foo"));
        IDocumentChange undoChange = new DocumentChangeOperation(this.document, (IDocumentChange)change).execute();
        DocumentChangeOperationTest.assertEquals((String)"foo", (String)this.document.get());
        IDocumentChange redoChange = new DocumentChangeOperation(this.document, undoChange).execute();
        DocumentChangeOperationTest.assertEquals((String)"", (String)this.document.get());
        new DocumentChangeOperation(this.document, redoChange).execute();
        DocumentChangeOperationTest.assertEquals((String)"foo", (String)this.document.get());
    }

    public void test2() throws Exception {
        DocumentChange change = new DocumentChange((TextEdit)new InsertEdit(0, "foo"));
        change.setStyle(0);
        DocumentChangeOperationTest.assertNull((Object)new DocumentChangeOperation(this.document, (IDocumentChange)change).execute());
    }

    public void test3() throws Exception {
        DocumentChange change = new DocumentChange((TextEdit)new InsertEdit(0, "foo"));
        change.setBase((ISnapshot)new DocumentSnapshot(this.document));
        this.document.set("bar");
        try {
            new DocumentChangeOperation(this.document, (IDocumentChange)change).execute();
            DocumentChangeOperationTest.fail();
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
    }

    public void test4() throws Exception {
        DocumentChange change = new DocumentChange((TextEdit)new InsertEdit(0, "foo"));
        IDocumentChange undoChange = new DocumentChangeOperation(this.document, (IDocumentChange)change).execute();
        this.document.set("");
        try {
            new DocumentChangeOperation(this.document, undoChange).execute();
            DocumentChangeOperationTest.fail();
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
    }
}

