/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import junit.framework.TestCase;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.handly.model.impl.support.ElementCache;
import org.eclipse.handly.model.impl.support.SimpleElement;

public class ElementCacheTest
extends TestCase {
    private ElementCache cache;
    private SimpleElement a;
    private SimpleElement b;

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = new ElementCache(10);
        this.a = new SimpleElement(null, "A", null);
        this.b = this.a.getChild("B");
    }

    public void test1() {
        ElementCacheTest.assertEquals((int)10, (int)this.cache.maxSize());
        this.cache.ensureMaxSize(100, (IElement)this.a);
        int maxSize = this.cache.maxSize();
        ElementCacheTest.assertTrue((maxSize > 100 ? 1 : 0) != 0);
        this.cache.resetMaxSize(10, (IElement)this.b);
        ElementCacheTest.assertEquals((int)maxSize, (int)this.cache.maxSize());
        this.cache.resetMaxSize(10, (IElement)this.a);
        ElementCacheTest.assertEquals((int)10, (int)this.cache.maxSize());
        this.cache.resetMaxSize(100, (IElement)this.a);
        ElementCacheTest.assertEquals((int)10, (int)this.cache.maxSize());
    }

    public void test2() {
        ElementCacheTest.assertEquals((int)10, (int)this.cache.maxSize());
        this.cache.ensureMaxSize(100, (IElement)this.a);
        ElementCacheTest.assertTrue((this.cache.maxSize() > 100 ? 1 : 0) != 0);
        this.cache.ensureMaxSize(1000, (IElement)this.b);
        int maxSize = this.cache.maxSize();
        ElementCacheTest.assertTrue((maxSize > 1000 ? 1 : 0) != 0);
        this.cache.resetMaxSize(10, (IElement)this.a);
        ElementCacheTest.assertEquals((int)maxSize, (int)this.cache.maxSize());
        this.cache.resetMaxSize(10, (IElement)this.b);
        ElementCacheTest.assertEquals((int)10, (int)this.cache.maxSize());
    }

    public void test3() {
        ElementCacheTest.assertEquals((int)10, (int)this.cache.maxSize());
        this.cache.ensureMaxSize(100, (IElement)this.a);
        int maxSize = this.cache.maxSize();
        ElementCacheTest.assertTrue((maxSize > 100 ? 1 : 0) != 0);
        this.cache.ensureMaxSize(50, (IElement)this.b);
        ElementCacheTest.assertEquals((int)maxSize, (int)this.cache.maxSize());
        this.cache.resetMaxSize(10, (IElement)this.b);
        ElementCacheTest.assertEquals((int)maxSize, (int)this.cache.maxSize());
        this.cache.resetMaxSize(10, (IElement)this.a);
        ElementCacheTest.assertEquals((int)10, (int)this.cache.maxSize());
    }

    public void test4() {
        this.cache.setMaxSize(1);
        class Element
        extends SimpleElement {
            IElementImplExtension.CloseHint closeHint;

            Element(String name) {
                super(null, name, null);
            }

            public void close_(IContext context) {
                this.closeHint = (IElementImplExtension.CloseHint)context.get(CLOSE_HINT);
            }
        }
        Element e1 = new Element("E1");
        this.cache.put((Object)e1, new Object());
        ElementCacheTest.assertNull((Object)e1.closeHint);
        Element e2 = new Element("E2");
        this.cache.put((Object)e2, new Object());
        ElementCacheTest.assertEquals((Object)IElementImplExtension.CloseHint.CACHE_OVERFLOW, (Object)e1.closeHint);
        ElementCacheTest.assertEquals((int)1, (int)this.cache.getOverflow());
        ElementCacheTest.assertNull((Object)e2.closeHint);
    }

    public void test5() {
        class Element
        extends SimpleElement {
            Element(String name) {
                super(null, name, null);
            }

            public void close_(IContext context) {
                ElementCacheTest.this.cache.remove((Object)this);
            }
        }
        ElementCacheTest.assertEquals((int)10, (int)this.cache.maxSize());
        this.cache.setLoadFactor(0.5);
        int i = 0;
        while (i < 10) {
            this.cache.put((Object)new Element(Integer.toString(i)), new Object());
            ++i;
        }
        ElementCacheTest.assertEquals((int)this.cache.maxSize(), (int)this.cache.size());
        this.cache.put((Object)new Element("E"), new Object());
        ElementCacheTest.assertEquals((int)6, (int)this.cache.size());
    }
}

