/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.impl.IElementDeltaImpl;
import org.eclipse.handly.model.impl.support.IElementDeltaBuilder;
import org.eclipse.handly.util.IndentPolicy;
import org.eclipse.handly.util.ToStringOptions;

public class ElementDelta
implements IElementDeltaImpl {
    private static final ElementDelta[] NO_CHILDREN = new ElementDelta[0];
    private final IElement element;
    private int kind;
    private long flags;
    private IElement movedFromElement;
    private IElement movedToElement;
    private ElementDelta[] affectedChildren = NO_CHILDREN;
    private int affectedChildrenCounter;
    private Map<Key, Integer> childIndex;
    private IMarkerDelta[] markerDeltas;
    private IResourceDelta[] resourceDeltas;
    private int resourceDeltasCounter;

    public ElementDelta(IElement element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
    }

    @Override
    public final IElement getElement_() {
        return this.element;
    }

    @Override
    public final int getKind_() {
        return this.kind;
    }

    @Override
    public final long getFlags_() {
        return this.flags;
    }

    @Override
    public final ElementDelta findDelta_(IElement element) {
        if (element == null) {
            return null;
        }
        if (Elements.equalsAndSameParentChain(this.element, element)) {
            return this;
        }
        return this.findDescendant(new Key(element));
    }

    public final ElementDelta[] getAffectedChildren_() {
        if (this.affectedChildren.length != this.affectedChildrenCounter) {
            this.affectedChildren = Arrays.copyOf(this.affectedChildren, this.affectedChildrenCounter);
        }
        return this.affectedChildren;
    }

    public final ElementDelta[] getAddedChildren_() {
        return this.getChildrenOfKind(1);
    }

    public final ElementDelta[] getRemovedChildren_() {
        return this.getChildrenOfKind(2);
    }

    public final ElementDelta[] getChangedChildren_() {
        return this.getChildrenOfKind(4);
    }

    @Override
    public final IElement getMovedFromElement_() {
        return this.movedFromElement;
    }

    @Override
    public final IElement getMovedToElement_() {
        return this.movedToElement;
    }

    @Override
    public final IMarkerDelta[] getMarkerDeltas_() {
        return this.markerDeltas;
    }

    @Override
    public final IResourceDelta[] getResourceDeltas_() {
        if (this.resourceDeltas != null && this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    public String toString() {
        return this.toString_(Contexts.EMPTY_CONTEXT);
    }

    @Override
    public String toString_(IContext context) {
        StringBuilder builder = new StringBuilder();
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        int indentLevel = context.getOrDefault(ToStringOptions.INDENT_LEVEL);
        indentPolicy.appendIndent(builder, indentLevel);
        builder.append(Elements.toString(this.element, Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.SHORT), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(0)), context)));
        builder.append('[');
        this.toStringKind_(builder, context);
        builder.append("]: {");
        this.toStringFlags_(builder, context);
        builder.append('}');
        ToStringOptions.FormatStyle style = context.getOrDefault(ToStringOptions.FORMAT_STYLE);
        if (style == ToStringOptions.FormatStyle.FULL || style == ToStringOptions.FormatStyle.LONG) {
            if (this.affectedChildrenCounter > 0) {
                indentPolicy.appendLine(builder);
                this.toStringChildren_(builder, Contexts.with(Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(indentLevel + 1)), context));
            }
            if (this.resourceDeltasCounter > 0) {
                indentPolicy.appendLine(builder);
                this.toStringResourceDeltas_(builder, Contexts.with(Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(indentLevel + 1)), context));
            }
        }
        return builder.toString();
    }

    protected void toStringChildren_(StringBuilder builder, IContext context) {
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        int i = 0;
        while (i < this.affectedChildrenCounter) {
            if (i > 0) {
                indentPolicy.appendLine(builder);
            }
            builder.append(this.affectedChildren[i].toString_(context));
            ++i;
        }
    }

    protected void toStringResourceDeltas_(StringBuilder builder, IContext context) {
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        int indentLevel = context.getOrDefault(ToStringOptions.INDENT_LEVEL);
        int i = 0;
        while (i < this.resourceDeltasCounter) {
            if (i > 0) {
                indentPolicy.appendLine(builder);
            }
            indentPolicy.appendIndent(builder, indentLevel);
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            builder.append("ResourceDelta(" + String.valueOf(resourceDelta.getFullPath()) + ")");
            builder.append('[');
            switch (resourceDelta.getKind()) {
                case 1: {
                    builder.append('+');
                    break;
                }
                case 2: {
                    builder.append('-');
                    break;
                }
                case 4: {
                    builder.append('*');
                    break;
                }
                default: {
                    builder.append('?');
                }
            }
            builder.append(']');
            ++i;
        }
    }

    protected void toStringKind_(StringBuilder builder, IContext context) {
        switch (this.getKind_()) {
            case 1: {
                builder.append('+');
                break;
            }
            case 2: {
                builder.append('-');
                break;
            }
            case 4: {
                builder.append('*');
                break;
            }
            default: {
                builder.append('?');
            }
        }
    }

    protected boolean toStringFlags_(StringBuilder builder, IContext context) {
        boolean prev = false;
        long flags = this.getFlags_();
        if ((flags & 2L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("CHILDREN");
            prev = true;
        }
        if ((flags & 1L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("CONTENT");
            prev = true;
        }
        if ((flags & 4L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("MOVED_FROM(");
            builder.append(Elements.toString(this.getMovedFromElement_(), Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(0)), context)));
            builder.append(')');
            prev = true;
        }
        if ((flags & 8L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("MOVED_TO(");
            builder.append(Elements.toString(this.getMovedToElement_(), Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(0)), context)));
            builder.append(')');
            prev = true;
        }
        if ((flags & 0x10L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("REORDERED");
            prev = true;
        }
        if ((flags & 0x20L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("FINE GRAINED");
            prev = true;
        }
        if ((flags & 0x40L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("OPEN");
            prev = true;
        }
        if ((flags & 0x80L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("DESCRIPTION");
            prev = true;
        }
        if ((flags & 0x100L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("WORKING COPY");
            prev = true;
        }
        if ((flags & 0x200L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("UNDERLYING RESOURCE");
            prev = true;
        }
        if ((flags & 0x400L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("MARKERS");
            prev = true;
        }
        if ((flags & 0x800L) != 0L) {
            if (prev) {
                builder.append(" | ");
            }
            builder.append("SYNC");
            prev = true;
        }
        return prev;
    }

    protected ElementDelta newDelta_(IElement element) {
        Factory factory = Elements.getModelContext(element).get(Factory.class);
        if (factory != null) {
            return factory.newDelta(element);
        }
        return new ElementDelta(element);
    }

    protected boolean needsChildIndex_() {
        return this.affectedChildrenCounter >= 3;
    }

    protected void setKind_(int kind) {
        this.kind = kind;
    }

    protected void setFlags_(long flags) {
        this.flags = flags;
    }

    protected void setMovedFromElement_(IElement movedFromElement) {
        this.movedFromElement = movedFromElement;
    }

    protected void setMovedToElement_(IElement movedToElement) {
        this.movedToElement = movedToElement;
    }

    protected void setMarkerDeltas_(IMarkerDelta[] markerDeltas) {
        this.markerDeltas = markerDeltas;
    }

    protected void setResourceDeltas_(IResourceDelta[] resourceDeltas) {
        this.resourceDeltas = resourceDeltas;
        this.resourceDeltasCounter = resourceDeltas != null ? resourceDeltas.length : 0;
    }

    protected void addResourceDelta_(IResourceDelta resourceDelta) {
        if (resourceDelta == null) {
            throw new IllegalArgumentException();
        }
        switch (this.getKind_()) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.setFlags_(this.getFlags_() | 1L);
                break;
            }
            default: {
                this.setKind_(4);
                this.setFlags_(this.getFlags_() | 1L);
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = resourceDelta;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = resourceDelta;
    }

    protected void insertSubTree_(ElementDelta delta) {
        this.addAffectedChild_(this.createDeltaTree(delta));
    }

    protected void addAffectedChild_(ElementDelta child) {
        Key key;
        Integer index;
        switch (this.getKind_()) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.setFlags_(this.getFlags_() | 2L);
                break;
            }
            default: {
                this.setKind_(4);
                this.setFlags_(this.getFlags_() | 2L);
            }
        }
        if (this.element instanceof ISourceElement) {
            this.setFlags_(this.getFlags_() | 0x20L);
        }
        if ((index = this.indexOfChild(key = new Key(child.element))) == null) {
            this.addNewChild(child);
        } else {
            ElementDelta existingChild = this.affectedChildren[index];
            boolean wasEmpty = existingChild.isEmpty_();
            existingChild.mergeWith_(child);
            if (!wasEmpty && existingChild.isEmpty_()) {
                this.removeExistingChild(key, index);
            }
        }
    }

    protected void mergeWith_(ElementDelta delta) {
        switch (this.getKind_()) {
            case 1: {
                switch (delta.getKind_()) {
                    case 1: 
                    case 4: {
                        return;
                    }
                    case 2: {
                        this.copyFrom_(this.newDelta_(this.getElement_()), true);
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getKind_()) {
                    case 1: {
                        ElementDelta newDelta = this.newDelta_(this.getElement_());
                        newDelta.setKind_(4);
                        newDelta.setFlags_(1L);
                        this.copyFrom_(newDelta, true);
                        return;
                    }
                    case 2: 
                    case 4: {
                        return;
                    }
                }
                break;
            }
            case 4: {
                switch (delta.getKind_()) {
                    case 1: 
                    case 2: {
                        this.copyFrom_(delta, true);
                        return;
                    }
                    case 4: {
                        this.copyFrom_(delta, false);
                        return;
                    }
                }
                break;
            }
            default: {
                this.copyFrom_(delta, true);
                return;
            }
        }
    }

    protected void copyFrom_(ElementDelta delta, boolean init) {
        if (init) {
            this.setKind_(delta.getKind_());
            this.setFlags_(delta.getFlags_());
            this.setMovedFromElement_(delta.getMovedFromElement_());
            this.setMovedToElement_(delta.getMovedToElement_());
            this.setAffectedChildren_(delta.getAffectedChildren_());
            this.setMarkerDeltas_(delta.getMarkerDeltas_());
            this.setResourceDeltas_(delta.getResourceDeltas_());
        } else {
            if (delta.getKind_() == 0) {
                return;
            }
            if (this.getKind_() == 0) {
                this.setKind_(delta.getKind_());
            } else if (this.getKind_() != delta.getKind_()) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < delta.affectedChildrenCounter) {
                this.addAffectedChild_(delta.affectedChildren[i]);
                ++i;
            }
            if (delta.markerDeltas != null) {
                if (this.markerDeltas != null) {
                    throw new AssertionError((Object)"Merge of marker deltas is not supported");
                }
                this.setMarkerDeltas_(delta.getMarkerDeltas_());
            }
            i = 0;
            while (i < delta.resourceDeltasCounter) {
                this.addResourceDelta_(delta.resourceDeltas[i]);
                ++i;
            }
            this.setFlags_(this.getFlags_() | delta.getFlags_());
        }
    }

    protected void setAffectedChildren_(ElementDelta[] children) {
        if (children == null) {
            throw new IllegalArgumentException();
        }
        this.affectedChildren = children;
        this.affectedChildrenCounter = children.length;
        this.childIndex = null;
    }

    private ElementDelta createDeltaTree(ElementDelta delta) {
        ElementDelta childDelta = delta;
        List<IElement> ancestors = this.getAncestors(delta.element);
        if (ancestors == null) {
            IContext context = Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.SHORT);
            throw new IllegalArgumentException(MessageFormat.format("Delta {0} cannot be rooted in {1}", delta.toString_(context), this.toString_(context)));
        }
        for (IElement ancestor : ancestors) {
            ElementDelta ancestorDelta = this.newDelta_(ancestor);
            ancestorDelta.addAffectedChild_(childDelta);
            childDelta = ancestorDelta;
        }
        return childDelta;
    }

    private List<IElement> getAncestors(IElement child) {
        IElement parent = Elements.getParent(child);
        if (parent == null) {
            return null;
        }
        ArrayList<IElement> parents = new ArrayList<IElement>();
        while (!Elements.equalsAndSameParentChain(parent, this.element)) {
            parents.add(parent);
            parent = Elements.getParent(parent);
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    private ElementDelta[] getChildrenOfKind(int kind) {
        if (this.affectedChildren.length == 0) {
            return this.affectedChildren;
        }
        ArrayList<ElementDelta> children = new ArrayList<ElementDelta>(this.affectedChildrenCounter);
        int i = 0;
        while (i < this.affectedChildrenCounter) {
            ElementDelta child = this.affectedChildren[i];
            if (child.getKind_() == kind) {
                children.add(child);
            }
            ++i;
        }
        if (children.size() == this.affectedChildren.length) {
            return this.affectedChildren;
        }
        ElementDelta[] result = (ElementDelta[])Array.newInstance(this.affectedChildren.getClass().getComponentType(), children.size());
        return children.toArray(result);
    }

    private ElementDelta findDescendant(Key key) {
        if (this.affectedChildrenCounter == 0 || !Elements.isAncestorOf(this.element, Elements.getParent(key.element))) {
            return null;
        }
        Integer index = this.indexOfChild(key);
        if (index != null) {
            return this.affectedChildren[index];
        }
        int i = 0;
        while (i < this.affectedChildrenCounter) {
            ElementDelta delta = this.affectedChildren[i].findDescendant(key);
            if (delta != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    private Integer indexOfChild(Key key) {
        if (!this.needsChildIndex_()) {
            int i = 0;
            while (i < this.affectedChildrenCounter) {
                if (Elements.equalsAndSameParentChain(key.element, this.affectedChildren[i].element)) {
                    return i;
                }
                ++i;
            }
            return null;
        }
        if (this.childIndex == null) {
            this.childIndex = new HashMap<Key, Integer>();
            int i = 0;
            while (i < this.affectedChildrenCounter) {
                this.childIndex.put(new Key(this.affectedChildren[i].element), i);
                ++i;
            }
        }
        return this.childIndex.get(key);
    }

    private void addNewChild(ElementDelta child) {
        int length = this.affectedChildren.length;
        if (length == this.affectedChildrenCounter) {
            int newLength = length == 0 ? 1 : length * 2;
            this.affectedChildren = Arrays.copyOf(this.affectedChildren, newLength);
        }
        this.affectedChildren[this.affectedChildrenCounter++] = child;
        if (this.childIndex != null) {
            this.childIndex.put(new Key(child.element), this.affectedChildrenCounter - 1);
        }
    }

    private void removeExistingChild(Key key, int index) {
        int rest;
        if (this.affectedChildren.length == this.affectedChildrenCounter) {
            this.affectedChildren = (ElementDelta[])this.affectedChildren.clone();
        }
        if ((rest = this.affectedChildrenCounter - index - 1) > 0) {
            System.arraycopy(this.affectedChildren, index + 1, this.affectedChildren, index, rest);
        }
        this.affectedChildren[--this.affectedChildrenCounter] = null;
        if (this.childIndex != null) {
            if (!this.needsChildIndex_()) {
                this.childIndex = null;
            } else {
                this.childIndex.remove(key);
                int i = index;
                while (i < this.affectedChildrenCounter) {
                    this.childIndex.put(new Key(this.affectedChildren[i].element), i);
                    ++i;
                }
            }
        }
    }

    public static class Builder
    implements IElementDeltaBuilder {
        private final ElementDelta rootDelta;

        public Builder(ElementDelta rootDelta) {
            if (rootDelta == null) {
                throw new IllegalArgumentException();
            }
            this.rootDelta = rootDelta;
        }

        @Override
        public ElementDelta getDelta() {
            return this.rootDelta;
        }

        @Override
        public Builder added(IElement element) {
            return this.added(element, 0L);
        }

        @Override
        public Builder added(IElement element, long flags) {
            this.insert(this.newAdded(element, flags));
            return this;
        }

        @Override
        public Builder removed(IElement element) {
            return this.removed(element, 0L);
        }

        @Override
        public Builder removed(IElement element, long flags) {
            this.insert(this.newRemoved(element, flags));
            return this;
        }

        @Override
        public Builder changed(IElement element, long flags) {
            this.insert(this.newChanged(element, flags));
            return this;
        }

        @Override
        public Builder movedFrom(IElement movedFromElement, IElement movedToElement) {
            this.insert(this.newMovedFrom(movedFromElement, movedToElement));
            return this;
        }

        @Override
        public Builder movedTo(IElement movedToElement, IElement movedFromElement) {
            this.insert(this.newMovedTo(movedToElement, movedFromElement));
            return this;
        }

        @Override
        public Builder markersChanged(IElement element, IMarkerDelta[] markerDeltas) {
            if (markerDeltas == null || markerDeltas.length == 0) {
                throw new IllegalArgumentException();
            }
            ElementDelta delta = this.newChanged(element, 1024L);
            delta.setMarkerDeltas_(markerDeltas);
            this.insert(delta);
            return this;
        }

        @Override
        public Builder addResourceDelta(IElement element, IResourceDelta resourceDelta) {
            if (resourceDelta == null) {
                throw new IllegalArgumentException();
            }
            ElementDelta delta = this.newChanged(element, 1L);
            delta.addResourceDelta_(resourceDelta);
            this.insert(delta);
            return this;
        }

        private void insert(ElementDelta delta) {
            if (!Elements.equalsAndSameParentChain(this.rootDelta.element, delta.element)) {
                this.rootDelta.insertSubTree_(delta);
            } else {
                this.rootDelta.mergeWith_(delta);
            }
        }

        private ElementDelta newAdded(IElement element, long flags) {
            ElementDelta delta = this.rootDelta.newDelta_(element);
            delta.setKind_(1);
            delta.setFlags_(flags);
            return delta;
        }

        private ElementDelta newRemoved(IElement element, long flags) {
            ElementDelta delta = this.rootDelta.newDelta_(element);
            delta.setKind_(2);
            delta.setFlags_(flags);
            return delta;
        }

        private ElementDelta newChanged(IElement element, long flags) {
            ElementDelta delta = this.rootDelta.newDelta_(element);
            delta.setKind_(4);
            delta.setFlags_(flags);
            return delta;
        }

        private ElementDelta newMovedFrom(IElement movedFromElement, IElement movedToElement) {
            ElementDelta delta = this.newRemoved(movedFromElement, 8L);
            if (movedToElement == null) {
                throw new IllegalArgumentException();
            }
            delta.setMovedToElement_(movedToElement);
            return delta;
        }

        private ElementDelta newMovedTo(IElement movedToElement, IElement movedFromElement) {
            ElementDelta delta = this.newAdded(movedToElement, 4L);
            if (movedFromElement == null) {
                throw new IllegalArgumentException();
            }
            delta.setMovedFromElement_(movedFromElement);
            return delta;
        }
    }

    public static interface Factory {
        public ElementDelta newDelta(IElement var1);
    }

    private static class Key {
        final IElement element;

        Key(IElement element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            this.element = element;
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            return Elements.equalsAndSameParentChain(this.element, ((Key)obj).element);
        }
    }
}

