/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.cdt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.etrice.generator.ui.cdt.Activator;
import org.eclipse.etrice.generator.ui.configurator.IProjectConfigurator;

public abstract class ProjectConfigurator
implements IProjectConfigurator {
    private static boolean traceIncludeIds;
    static final String MINGW_TOOLCHAIN = "MinGW GCC";
    static final String POSIX_TOOLCHAIN = "Linux GCC";
    private boolean copyRuntime;
    private String platform;
    private IPath path;

    static {
        String value;
        traceIncludeIds = false;
        if (Activator.getDefault() != null && Activator.getDefault().isDebugging() && (value = Platform.getDebugOption((String)"org.eclipse.etrice.generator.ui.cdt/trace/includeIDs")) != null && value.equalsIgnoreCase(Boolean.toString(true))) {
            traceIncludeIds = true;
        }
    }

    protected abstract boolean isApplicable(IProject var1);

    protected abstract boolean isIncludePathId(String var1);

    protected abstract List<CIncludePathEntry> getIncludePaths();

    protected abstract Map<String, String> getProjectRefInfo(ICConfigurationDescription var1, String var2);

    protected abstract void copyRuntime(IProject var1, IProgressMonitor var2, String var3);

    protected abstract void customizeBuildConfig(IProject var1, IConfiguration var2);

    protected abstract void configureModelpath(IProject var1, IPath var2);

    public void configure(IProject project, IPath path, boolean copyRuntime, String platform, IProgressMonitor progressMonitor) {
        this.copyRuntime = copyRuntime;
        this.platform = platform;
        this.path = path;
        try {
            if (this.isApplicable(project)) {
                if (copyRuntime) {
                    this.copyRuntime(project, progressMonitor, platform);
                }
                this.configureModelpath(project, path);
                this.configureIncludesAndLibraries(project, progressMonitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected IPath getPath() {
        return this.path;
    }

    protected String getPlatform() {
        return this.platform;
    }

    protected boolean isCopyRuntime() {
        return this.copyRuntime;
    }

    protected void configureIncludesAndLibraries(IProject project, IProgressMonitor progressMonitor) throws CoreException {
        if (traceIncludeIds) {
            System.out.println("org.eclipse.etrice.generator.ui.cdt.ProjectConfigurator.configureIncludesAndLibraries(IProject, IProgressMonitor)");
        }
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDescription.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            if (configDescription.getId() != null) {
                IConfiguration buildConfig = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescription);
                String toolChain = "";
                String toolChainName = buildConfig.getToolChain().getName();
                if (MINGW_TOOLCHAIN.equals(toolChainName)) {
                    toolChain = MINGW_TOOLCHAIN;
                } else if (POSIX_TOOLCHAIN.equals(toolChainName)) {
                    toolChain = POSIX_TOOLCHAIN;
                }
                this.customizeBuildConfig(project, buildConfig);
                configDescription.setReferenceInfo(this.getProjectRefInfo(configDescription, toolChain));
                ICLanguageSetting[] iCLanguageSettingArray = configDescription.getRootFolderDescription().getLanguageSettings();
                int n3 = iCLanguageSettingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICLanguageSetting setting = iCLanguageSettingArray[n4];
                    if (setting.getId() != null) {
                        if (traceIncludeIds) {
                            System.out.println("  config '" + buildConfig.getName() + "', toolchain '" + toolChainName + "', settingID '" + setting.getId() + "'");
                        }
                        if (this.isIncludePathId(setting.getId())) {
                            this.addSettings(setting, 1, this.getIncludePaths());
                        }
                        if (setting.getId().startsWith("cdt.managedbuild.tool.gnu.c.linker")) {
                            ArrayList<CLibraryFileEntry> libraries = new ArrayList<CLibraryFileEntry>();
                            if (toolChain == POSIX_TOOLCHAIN) {
                                libraries.add(new CLibraryFileEntry("pthread", 4));
                                libraries.add(new CLibraryFileEntry("rt", 4));
                            } else if (toolChain == MINGW_TOOLCHAIN) {
                                libraries.add(new CLibraryFileEntry("ws2_32", 4));
                            }
                            this.addSettings(setting, 32, libraries);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(project, projectDescription);
    }

    private void addSettings(ICLanguageSetting setting, int kind, List<? extends ICLanguageSettingEntry> newEntries) {
        HashSet<String> valueSet = new HashSet<String>();
        for (ICLanguageSettingEntry entry : setting.getSettingEntriesList(kind)) {
            valueSet.add(entry.getValue());
        }
        ArrayList<ICLanguageSettingEntry> allEntries = new ArrayList<ICLanguageSettingEntry>();
        for (ICLanguageSettingEntry iCLanguageSettingEntry : setting.getSettingEntriesList(kind)) {
            allEntries.add(iCLanguageSettingEntry);
        }
        for (ICLanguageSettingEntry iCLanguageSettingEntry : newEntries) {
            if (valueSet.contains(iCLanguageSettingEntry.getValue())) continue;
            allEntries.add(iCLanguageSettingEntry);
        }
        setting.setSettingEntries(kind, allEntries);
    }
}

