/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericStateMachineGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
public class StateMachineGen
extends GenericStateMachineGenerator {
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    private final NodeComparator nodeComparator = new NodeComparator();

    public CharSequence genExtra(GraphContainer gc, boolean generateImplementation) {
        StringConcatenation stringConcatenation = null;
        ModelComponent ac = gc.getComponent();
        String clsName = ac.getComponentName();
        List orderedStateNodes = IterableExtensions.sortWith((Iterable)IteratorExtensions.toList((Iterator)FsmGenExtensions.getAllStateNodes((Graph)gc.getGraph())), (Comparator)this.nodeComparator);
        StringConcatenation stringConcatenation2 = null;
        if (generateImplementation) {
            int n;
            StringConcatenation stringConcatenation3 = new StringConcatenation();
            if (this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) || this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
                stringConcatenation3.append("// state names");
                stringConcatenation3.newLine();
                stringConcatenation3.append("const String ");
                stringConcatenation3.append(clsName);
                stringConcatenation3.append("::s_stateStrings[] = {");
                stringConcatenation3.newLineIfNotEmpty();
                stringConcatenation3.append("\t");
                stringConcatenation3.append("\"<no state>\",");
                stringConcatenation3.newLine();
                stringConcatenation3.append("\t");
                stringConcatenation3.append("\"<top>\",");
                stringConcatenation3.newLine();
                n = 0;
                for (Node state : orderedStateNodes) {
                    if (n == 0) {
                        n = 1;
                    } else {
                        stringConcatenation3.appendImmediate((Object)",", "\t");
                    }
                    stringConcatenation3.append("\t");
                    stringConcatenation3.append("\"");
                    StateGraphNode stateGraphNode = state.getStateGraphNode();
                    String string = this._codegenHelpers.getGenStatePathName((State)stateGraphNode);
                    stringConcatenation3.append(string, "\t");
                    stringConcatenation3.append("\"");
                    stringConcatenation3.newLineIfNotEmpty();
                }
                stringConcatenation3.append("};");
                stringConcatenation3.newLine();
            }
            stringConcatenation3.append("const int ");
            stringConcatenation3.append(clsName);
            stringConcatenation3.append("::s_numberOfStates = ");
            n = orderedStateNodes.size();
            int n2 = 2 + n;
            stringConcatenation3.append((Object)n2);
            stringConcatenation3.append(";");
            stringConcatenation3.newLineIfNotEmpty();
            stringConcatenation3.newLine();
            stringConcatenation3.append("void ");
            stringConcatenation3.append(clsName);
            stringConcatenation3.append("::setState(int new_state) {");
            stringConcatenation3.newLineIfNotEmpty();
            boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (bl) {
                stringConcatenation3.append("\t");
                stringConcatenation3.append("DebuggingService::getInstance().addActorState(*this, s_stateStrings[new_state].c_str());");
                stringConcatenation3.newLine();
            }
            if (bl = this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
                stringConcatenation3.append("\t");
                stringConcatenation3.append("if (s_stateStrings[new_state] != \"Idle\") {");
                stringConcatenation3.newLine();
                stringConcatenation3.append("\t");
                stringConcatenation3.append("\t");
                stringConcatenation3.append("std::cout << getInstancePath().c_str() << \" -> \" << s_stateStrings[new_state].c_str() << std::endl;");
                stringConcatenation3.newLine();
                stringConcatenation3.append("\t");
                stringConcatenation3.append("}");
                stringConcatenation3.newLine();
            }
            stringConcatenation3.append("\t");
            stringConcatenation3.append("m_state = new_state;");
            stringConcatenation3.newLine();
            stringConcatenation3.append("}");
            stringConcatenation3.newLine();
            stringConcatenation2 = stringConcatenation3;
        } else {
            StringConcatenation stringConcatenation4 = new StringConcatenation();
            if (this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) || this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
                stringConcatenation4.append("static const String s_stateStrings[];");
                stringConcatenation4.newLine();
            }
            stringConcatenation4.append("static const int s_numberOfStates;");
            stringConcatenation4.newLine();
            stringConcatenation4.newLine();
            stringConcatenation4.append("int history[");
            int n = orderedStateNodes.size();
            int n3 = 2 + n;
            stringConcatenation4.append((Object)n3);
            stringConcatenation4.append("];");
            stringConcatenation4.newLineIfNotEmpty();
            stringConcatenation4.newLine();
            stringConcatenation4.append("void setState(int new_state);");
            stringConcatenation4.newLine();
            stringConcatenation2 = stringConcatenation4;
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public String stateType() {
        return "etInt16";
    }

    public String boolType() {
        return "etBool";
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            int n;
            boolean bl;
            int n2 = o1.getInheritanceLevel();
            boolean bl2 = bl = n2 == (n = o2.getInheritanceLevel());
            if (bl) {
                if (FsmGenExtensions.isLeaf((Node)o1) && FsmGenExtensions.isLeaf((Node)o2)) {
                    return 0;
                }
                boolean bl3 = FsmGenExtensions.isLeaf((Node)o1);
                if (bl3) {
                    return 1;
                }
                boolean bl4 = FsmGenExtensions.isLeaf((Node)o2);
                if (bl4) {
                    return -1;
                }
                return 0;
            }
            return Integer.compare(o1.getInheritanceLevel(), o1.getInheritanceLevel());
        }
    }
}

