/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.common.CifExternalFuncUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.BreakFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ContinueFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ElifFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.IfFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.WhileFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.AFuncDecl;
import org.eclipse.escet.cif.parser.ast.automata.ALocation;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.parser.ast.functions.AAssignFuncStatement;
import org.eclipse.escet.cif.parser.ast.functions.ABreakFuncStatement;
import org.eclipse.escet.cif.parser.ast.functions.AContinueFuncStatement;
import org.eclipse.escet.cif.parser.ast.functions.AElifFuncStatement;
import org.eclipse.escet.cif.parser.ast.functions.AExternalFuncBody;
import org.eclipse.escet.cif.parser.ast.functions.AFuncStatement;
import org.eclipse.escet.cif.parser.ast.functions.AIfFuncStatement;
import org.eclipse.escet.cif.parser.ast.functions.AInternalFuncBody;
import org.eclipse.escet.cif.parser.ast.functions.AReturnFuncStatement;
import org.eclipse.escet.cif.parser.ast.functions.AWhileFuncStatement;
import org.eclipse.escet.cif.parser.ast.types.ACifType;
import org.eclipse.escet.cif.typechecker.AssignmentUniquenessChecker;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeCheckerProblemReporter;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.ExprContext;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.declwrap.ConstDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EnumDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EnumLiteralDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FuncParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FuncVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.TypeDeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.app.framework.PlatformUriUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class FunctionScope
extends ParentScope<Function> {
    private static final ExprContext FUNC_CTXT = ExprContext.DEFAULT_CTXT.add(ExprContext.Condition.NO_TIME);
    private final AFuncDecl astDecl;
    public boolean used = false;
    private CifType returnType = null;

    public FunctionScope(Function obj, AFuncDecl astDecl, ParentScope<?> parent, CifTypeChecker tchecker) {
        super(obj, parent, tchecker);
        this.astDecl = astDecl;
    }

    public CifType getReturnType() {
        Assert.notNull((Object)this.returnType);
        return this.returnType;
    }

    @Override
    public String getName() {
        return ((Function)this.obj).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.obj);
    }

    @Override
    public String getAbsText() {
        return Strings.fmt((String)"function \"%s\"", (Object[])new Object[]{this.getAbsName()});
    }

    @Override
    protected String getScopeTypeName() {
        return "func";
    }

    @Override
    protected ComplexComponent getComplexComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Group getGroup() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ComponentDef getComponentDef() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Automaton getAutomaton() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ALocation> getAstLocs() {
        return null;
    }

    @Override
    public void addChildScope(SymbolScope<?> scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void tcheckScopeForUse() {
        this.tchecker.addToCycle(this);
        List returnTypes = Lists.list();
        try {
            for (ACifType astType : this.astDecl.returnTypes) {
                CifType retType = CifTypesTypeChecker.transCifType(astType, this.getParent(), this.tchecker);
                returnTypes.add(retType);
                if (!CifTypeUtils.hasComponentLikeType((CifType)retType)) continue;
                this.tchecker.addProblem(ErrMsg.TYPE_INVALID_TYPE, retType.getPosition(), CifTextUtils.typeToStr((CifType)retType), "return values of functions");
                throw new SemanticException();
            }
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        ((Function)this.obj).getReturnTypes().addAll((Collection)returnTypes);
        Assert.check((!returnTypes.isEmpty() ? 1 : 0) != 0);
        this.returnType = CifTypeUtils.makeTupleType((List)returnTypes, (Position)this.getPosition());
        this.tchecker.addToCycle(this);
        try {
            for (DeclWrap decl : this.declarations.values()) {
                if (!(decl instanceof FuncParamDeclWrap)) continue;
                decl.tcheckForUse();
            }
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
    }

    @Override
    protected void tcheckScopeFull() {
        if (CifValueUtils.getPossibleValueCount((CifType)this.returnType) == 1.0) {
            this.tchecker.addProblem(ErrMsg.TYPE_ONE_VALUE, this.returnType.getPosition(), "return ", CifTextUtils.typeToStr((CifType)this.returnType), "function", CifTextUtils.getAbsName((PositionObject)this.obj, (boolean)false), "function");
        }
        if (this.astDecl.body instanceof AInternalFuncBody) {
            this.tcheckInternalFuncBody((AInternalFuncBody)this.astDecl.body);
        } else {
            Assert.check((boolean)(this.astDecl.body instanceof AExternalFuncBody));
            this.tcheckExternalFuncBody((AExternalFuncBody)this.astDecl.body);
        }
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.astDecl.annotations, this, this.tchecker);
        ((Function)this.obj).getAnnotations().addAll(annos);
    }

    private void tcheckInternalFuncBody(AInternalFuncBody body) {
        InternalFunction ifunc = (InternalFunction)this.obj;
        boolean reachable = true;
        for (AFuncStatement stat : body.statements) {
            reachable = this.typeCheckStatement(stat, (List<FunctionStatement>)ifunc.getStatements(), false, reachable);
        }
        this.checkEndsWithReturn((List<FunctionStatement>)ifunc.getStatements());
    }

    private void tcheckExternalFuncBody(AExternalFuncBody body) {
        for (DeclWrap decl : this.declarations.values()) {
            Assert.check((boolean)(decl instanceof FuncParamDeclWrap));
            decl.used = true;
        }
        ExternalFunction func = (ExternalFunction)this.obj;
        String extRef = func.getFunction();
        String langName = CifExternalFuncUtils.getLangName((String)extRef);
        if (langName.equals("java")) {
            this.tcheckExternalJavaFunc(func, extRef, body.position);
        } else {
            this.tchecker.addProblem(ErrMsg.UNSUPPORTED_EXT_FUNC_LANG, body.position, langName);
        }
    }

    private void tcheckExternalJavaFunc(ExternalFunction func, String extRef, TextPosition position) {
        String[] parts = CifExternalFuncUtils.splitExtJavaRef((String)extRef);
        String classPath = parts[3];
        if (classPath != null) {
            String[] entries = CifExternalFuncUtils.splitJavaClassPathEntries((String)classPath);
            int i = 0;
            while (i < entries.length) {
                String entry = entries[i];
                String absEntry = this.tchecker.resolveImport(entry);
                if (!PlatformUriUtils.exists((String)absEntry)) {
                    this.tchecker.addProblem(ErrMsg.CLS_PATH_NOT_FOUND, position, entry);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < func.getParameters().size()) {
            FunctionParameter param = (FunctionParameter)func.getParameters().get(i);
            CifType paramType = param.getParameter().getType();
            if (!FunctionScope.tcheckJavaFuncType(paramType)) {
                this.tchecker.addProblem(ErrMsg.EXT_FUNC_PARAM_RET_TYPE, paramType.getPosition(), Numbers.toOrdinal((int)(i + 1)), "parameter", this.getAbsName(), CifTextUtils.typeToStr((CifType)paramType), "Java");
            }
            ++i;
        }
        i = 0;
        while (i < func.getReturnTypes().size()) {
            CifType retType = (CifType)func.getReturnTypes().get(i);
            if (!FunctionScope.tcheckJavaFuncType(retType)) {
                this.tchecker.addProblem(ErrMsg.EXT_FUNC_PARAM_RET_TYPE, retType.getPosition(), Numbers.toOrdinal((int)(i + 1)), "return value", this.getAbsName(), CifTextUtils.typeToStr((CifType)retType), "Java");
            }
            ++i;
        }
    }

    private static boolean tcheckJavaFuncType(CifType type) {
        if (type instanceof BoolType) {
            return true;
        }
        if (type instanceof IntType) {
            return true;
        }
        if (type instanceof TypeRef) {
            return FunctionScope.tcheckJavaFuncType(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            return false;
        }
        if (type instanceof RealType) {
            return true;
        }
        if (type instanceof StringType) {
            return true;
        }
        if (type instanceof ListType) {
            CifType etype = ((ListType)type).getElementType();
            return FunctionScope.tcheckJavaFuncType(etype);
        }
        if (type instanceof SetType) {
            CifType etype = ((SetType)type).getElementType();
            return FunctionScope.tcheckJavaFuncType(etype);
        }
        if (type instanceof FuncType) {
            return false;
        }
        if (type instanceof DictType) {
            CifType ktype = ((DictType)type).getKeyType();
            CifType vtype = ((DictType)type).getValueType();
            return FunctionScope.tcheckJavaFuncType(ktype) && FunctionScope.tcheckJavaFuncType(vtype);
        }
        if (type instanceof TupleType) {
            for (Field field : ((TupleType)type).getFields()) {
                if (FunctionScope.tcheckJavaFuncType(field.getType())) continue;
                return false;
            }
            return true;
        }
        if (type instanceof DistType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CifType wtype = ((CompInstWrapType)type).getReference();
            return FunctionScope.tcheckJavaFuncType(wtype);
        }
        if (type instanceof CompParamWrapType) {
            CifType wtype = ((CompParamWrapType)type).getReference();
            return FunctionScope.tcheckJavaFuncType(wtype);
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    private boolean typeCheckStatement(AFuncStatement stat, List<FunctionStatement> stats, boolean inWhile, boolean reachable) {
        if (!reachable) {
            this.tchecker.addProblem(ErrMsg.STAT_UNREACHABLE, stat.position, new String[0]);
        }
        if (stat instanceof AAssignFuncStatement) {
            TupleType ttype;
            AAssignFuncStatement asgn = (AAssignFuncStatement)stat;
            AssignmentFuncStatement astat = CifConstructors.newAssignmentFuncStatement();
            astat.setPosition(stat.createPosition());
            stats.add((FunctionStatement)astat);
            List addrs = Lists.list();
            for (AExpression addressable : asgn.addressables) {
                Expression addr = CifExprsTypeChecker.transExpression(addressable, CifExprsTypeChecker.NO_TYPE_HINT, this, FUNC_CTXT, this.tchecker);
                addrs.add(addr);
            }
            Expression addr = CifValueUtils.makeTuple((List)addrs, (Position)astat.getPosition());
            astat.setAddressable(addr);
            for (Expression expr : CifAddressableUtils.getRefExprs((Expression)addr)) {
                if (!(expr instanceof DiscVariableExpression)) {
                    Expression uexpr = CifTypeUtils.unwrapExpression((Expression)expr);
                    PositionObject obj = CifScopeUtils.getRefObjFromRef((Expression)uexpr);
                    this.tchecker.addProblem(ErrMsg.RESOLVE_NON_FUNC_VAR, expr.getPosition(), CifTextUtils.getAbsName((PositionObject)obj), this.getAbsName());
                    throw new SemanticException();
                }
                DiscVariable var = ((DiscVariableExpression)expr).getVariable();
                EObject func = var.eContainer();
                while (func != null && !(func instanceof Function)) {
                    func = func.eContainer();
                }
                Assert.notNull((Object)func);
                Assert.check((func == this.obj ? 1 : 0) != 0);
                PositionObject varAncestor = (PositionObject)expr.eContainer();
                while (varAncestor instanceof ProjectionExpression) {
                    ProjectionExpression proj = (ProjectionExpression)varAncestor;
                    CifType type = proj.getChild().getType();
                    CifType ntype = CifTypeUtils.normalizeType((CifType)type);
                    if (ntype instanceof StringType) {
                        this.tchecker.addProblem(ErrMsg.ASGN_STRING_PROJ, varAncestor.getPosition(), CifTextUtils.getAbsName((PositionObject)var));
                    }
                    varAncestor = (PositionObject)varAncestor.eContainer();
                }
            }
            CifType addrType = addr.getType();
            CifType naddrType = CifTypeUtils.normalizeType((CifType)addr.getType());
            CifType[] valueHints = new CifType[asgn.values.size()];
            if (asgn.values.size() == 1) {
                valueHints[0] = addrType;
            } else if (naddrType instanceof TupleType && (ttype = (TupleType)naddrType).getFields().size() == asgn.values.size()) {
                int i = 0;
                while (i < valueHints.length) {
                    valueHints[i] = ((Field)ttype.getFields().get(i)).getType();
                    ++i;
                }
            }
            List values = Lists.list();
            int i = 0;
            while (i < asgn.values.size()) {
                AExpression avalue = (AExpression)asgn.values.get(i);
                CifType valueHint = valueHints[i];
                Expression value = CifExprsTypeChecker.transExpression(avalue, valueHint, this, FUNC_CTXT, this.tchecker);
                values.add(value);
                ++i;
            }
            Expression value = CifValueUtils.makeTuple((List)values, (Position)astat.getPosition());
            astat.setValue(value);
            CifType valueType = value.getType();
            if (!CifTypeUtils.checkTypeCompat((CifType)addrType, (CifType)valueType, (RangeCompat)RangeCompat.OVERLAP)) {
                this.tchecker.addProblem(ErrMsg.ASGN_TYPE_VALUE_MISMATCH, stat.position, CifTextUtils.typeToStr((CifType)valueType), CifTextUtils.typeToStr((CifType)addrType));
            }
            Map asgnMap = Maps.map();
            AssignmentUniquenessChecker.checkUniqueAsgns(addr, (Map<Declaration, Set<Pair<Position, List<Object>>>>)asgnMap, (CifTypeCheckerProblemReporter)this.tchecker, ErrMsg.DUPL_VAR_ASGN_FUNC);
            return reachable;
        }
        if (stat instanceof ABreakFuncStatement) {
            BreakFuncStatement bstat = CifConstructors.newBreakFuncStatement();
            bstat.setPosition(stat.createPosition());
            stats.add((FunctionStatement)bstat);
            if (!inWhile) {
                this.tchecker.addProblem(ErrMsg.STAT_NOT_IN_WHILE, stat.position, "break");
            }
            return false;
        }
        if (stat instanceof AContinueFuncStatement) {
            ContinueFuncStatement cstat = CifConstructors.newContinueFuncStatement();
            cstat.setPosition(stat.createPosition());
            stats.add((FunctionStatement)cstat);
            if (!inWhile) {
                this.tchecker.addProblem(ErrMsg.STAT_NOT_IN_WHILE, stat.position, "continue");
            }
            return false;
        }
        if (stat instanceof AIfFuncStatement) {
            AIfFuncStatement astat = (AIfFuncStatement)stat;
            IfFuncStatement istat = CifConstructors.newIfFuncStatement();
            istat.setPosition(stat.createPosition());
            stats.add((FunctionStatement)istat);
            EList guards = istat.getGuards();
            for (AExpression g : astat.guards) {
                Expression guard = CifExprsTypeChecker.transExpression(g, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, this, FUNC_CTXT, this.tchecker);
                CifType t = guard.getType();
                CifType nt = CifTypeUtils.normalizeType((CifType)t);
                if (!(nt instanceof BoolType)) {
                    this.tchecker.addProblem(ErrMsg.GUARD_NON_BOOL, guard.getPosition(), CifTextUtils.typeToStr((CifType)t));
                }
                guards.add(guard);
            }
            EList thens = istat.getThens();
            boolean thenReachable = reachable;
            for (AFuncStatement thenStat : astat.thens) {
                thenReachable = this.typeCheckStatement(thenStat, (List<FunctionStatement>)thens, inWhile, thenReachable);
            }
            boolean elifsReachable = reachable;
            EList elifs = istat.getElifs();
            for (AElifFuncStatement elif1 : astat.elifs) {
                ElifFuncStatement elif2 = CifConstructors.newElifFuncStatement();
                elif2.setPosition(elif1.createPosition());
                elifs.add(elif2);
                guards = elif2.getGuards();
                for (AExpression g : elif1.guards) {
                    Expression guard = CifExprsTypeChecker.transExpression(g, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, this, FUNC_CTXT, this.tchecker);
                    CifType t = guard.getType();
                    CifType nt = CifTypeUtils.normalizeType((CifType)t);
                    if (!(nt instanceof BoolType)) {
                        this.tchecker.addProblem(ErrMsg.GUARD_NON_BOOL, guard.getPosition(), CifTextUtils.typeToStr((CifType)t));
                    }
                    guards.add(guard);
                }
                EList elifThens = elif2.getThens();
                boolean elifReachable = reachable;
                for (AFuncStatement elifStat : elif1.thens) {
                    elifReachable = this.typeCheckStatement(elifStat, (List<FunctionStatement>)elifThens, inWhile, elifReachable);
                }
                boolean bl = elifsReachable = elifsReachable && elifReachable;
            }
            if (astat.elifs.isEmpty()) {
                elifsReachable = false;
            }
            EList elses = istat.getElses();
            boolean elseReachable = reachable;
            if (astat.elseStat != null) {
                for (AFuncStatement elseStat : astat.elseStat.elses) {
                    elseReachable = this.typeCheckStatement(elseStat, (List<FunctionStatement>)elses, inWhile, elseReachable);
                }
            }
            return thenReachable || elifsReachable || elseReachable;
        }
        if (stat instanceof AReturnFuncStatement) {
            ReturnFuncStatement rstat = CifConstructors.newReturnFuncStatement();
            rstat.setPosition(stat.createPosition());
            stats.add((FunctionStatement)rstat);
            List avalues = ((AReturnFuncStatement)stat).values;
            int valueCnt = avalues.size();
            CifType[] valueHints = new CifType[valueCnt];
            if (valueCnt == 1) {
                valueHints[0] = this.returnType;
            } else if (this.returnType instanceof TupleType) {
                EList fields = ((TupleType)this.returnType).getFields();
                int cnt = Math.min(valueCnt, fields.size());
                int i = 0;
                while (i < cnt) {
                    valueHints[i] = ((Field)fields.get(i)).getType();
                    ++i;
                }
            }
            EList values = rstat.getValues();
            int i = 0;
            while (i < avalues.size()) {
                AExpression avalue = (AExpression)avalues.get(i);
                Expression value = CifExprsTypeChecker.transExpression(avalue, valueHints[i], this, FUNC_CTXT, this.tchecker);
                values.add(value);
                ++i;
            }
            Assert.check((!values.isEmpty() ? 1 : 0) != 0);
            CifType retStatType = CifTypeUtils.makeTupleTypeFromValues((List)values, (Position)rstat.getPosition());
            if (!CifTypeUtils.checkTypeCompat((CifType)this.returnType, (CifType)retStatType, (RangeCompat)RangeCompat.CONTAINED)) {
                this.tchecker.addProblem(ErrMsg.STAT_RETURN_TYPE, stat.position, CifTextUtils.typeToStr((CifType)retStatType), CifTextUtils.typeToStr((CifType)this.returnType), this.getAbsName());
            }
            return false;
        }
        if (stat instanceof AWhileFuncStatement) {
            AWhileFuncStatement awhile = (AWhileFuncStatement)stat;
            WhileFuncStatement wstat = CifConstructors.newWhileFuncStatement();
            wstat.setPosition(stat.createPosition());
            stats.add((FunctionStatement)wstat);
            EList guards = wstat.getGuards();
            for (AExpression g : awhile.guards) {
                Expression guard = CifExprsTypeChecker.transExpression(g, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, this, FUNC_CTXT, this.tchecker);
                CifType t = guard.getType();
                CifType nt = CifTypeUtils.normalizeType((CifType)t);
                if (!(nt instanceof BoolType)) {
                    this.tchecker.addProblem(ErrMsg.GUARD_NON_BOOL, guard.getPosition(), CifTextUtils.typeToStr((CifType)t));
                }
                guards.add(guard);
            }
            boolean bodyStatReachable = reachable;
            for (AFuncStatement bodyStat : awhile.statements) {
                bodyStatReachable = this.typeCheckStatement(bodyStat, (List<FunctionStatement>)wstat.getStatements(), true, bodyStatReachable);
            }
            return reachable;
        }
        throw new RuntimeException("Unknown func statement: " + String.valueOf(stat));
    }

    private void checkEndsWithReturn(List<FunctionStatement> stats) {
        this.checkEndsWithReturn((FunctionStatement)Lists.last(stats));
    }

    private void checkEndsWithReturn(FunctionStatement stat) {
        if (stat instanceof AssignmentFuncStatement) {
            this.tchecker.addProblem(ErrMsg.FUNC_NOT_END_RETURN, stat.getPosition(), this.getAbsName());
        } else if (stat instanceof BreakFuncStatement) {
            this.tchecker.addProblem(ErrMsg.FUNC_NOT_END_RETURN, stat.getPosition(), this.getAbsName());
        } else if (stat instanceof ContinueFuncStatement) {
            this.tchecker.addProblem(ErrMsg.FUNC_NOT_END_RETURN, stat.getPosition(), this.getAbsName());
        } else if (stat instanceof IfFuncStatement) {
            IfFuncStatement istat = (IfFuncStatement)stat;
            if (istat.getElses().isEmpty()) {
                this.tchecker.addProblem(ErrMsg.FUNC_NOT_END_RETURN, stat.getPosition(), this.getAbsName());
            } else {
                this.checkEndsWithReturn((List<FunctionStatement>)istat.getThens());
                for (ElifFuncStatement elif : istat.getElifs()) {
                    this.checkEndsWithReturn((List<FunctionStatement>)elif.getThens());
                }
                this.checkEndsWithReturn((List<FunctionStatement>)istat.getElses());
            }
        } else if (!(stat instanceof ReturnFuncStatement)) {
            if (stat instanceof WhileFuncStatement) {
                this.tchecker.addProblem(ErrMsg.FUNC_NOT_END_RETURN, stat.getPosition(), this.getAbsName());
            } else {
                throw new RuntimeException("Unknown function statement: " + String.valueOf(stat));
            }
        }
    }

    @Override
    public SymbolTableEntry resolve(TextPosition position, String name, CifTypeChecker tchecker, SymbolScope<?> originScope) {
        Assert.check((boolean)(this.obj instanceof InternalFunction));
        SymbolTableEntry entry = super.resolve(position, name, tchecker, originScope);
        if (entry instanceof ConstDeclWrap || entry instanceof EnumDeclWrap || entry instanceof EnumLiteralDeclWrap || entry instanceof FuncParamDeclWrap || entry instanceof FuncVariableDeclWrap || entry instanceof TypeDeclWrap || entry instanceof FunctionScope) {
            return entry;
        }
        tchecker.addProblem(ErrMsg.RESOLVE_NOT_IN_FUNC_SCOPE, position, entry.getAbsName(), this.getAbsName());
        throw new SemanticException();
    }

    @Override
    protected boolean isSubScope() {
        return true;
    }

    @Override
    protected boolean isRootScope() {
        return false;
    }
}

