/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.parser.ast.declarations.ATypeDef;
import org.eclipse.escet.cif.parser.ast.declarations.ATypeDefDecl;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class TypeDeclWrap
extends DeclWrap<TypeDecl> {
    private final ATypeDefDecl astDecls;
    private final ATypeDef astDecl;

    public TypeDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, ATypeDefDecl astDecls, ATypeDef astDecl, TypeDecl mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecls = astDecls;
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((TypeDecl)this.mmDecl).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.mmDecl);
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            CifType type = CifTypesTypeChecker.transCifType(this.astDecl.type, this.scope, this.tchecker);
            if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
                this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Type declaration", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
                throw new SemanticException();
            }
            ((TypeDecl)this.mmDecl).setType(type);
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.astDecls.annotations, this.scope, this.tchecker);
        ((TypeDecl)this.mmDecl).getAnnotations().addAll(annos);
        this.status = CheckStatus.FULL;
    }
}

