/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.JavaFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.JavaClassFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaFileManager;
import org.eclipse.escet.common.java.Assert;

public class RuntimeClassLoader
extends ClassLoader {
    public final Map<String, JavaClassFileObject> generatedClasses = new ConcurrentHashMap<String, JavaClassFileObject>();

    public RuntimeClassLoader(ClassLoader parent) {
        super(parent == null ? ClassLoader.getSystemClassLoader() : parent);
    }

    public void add(String absClassName, JavaClassFileObject file) {
        absClassName = RuntimeJavaFileManager.normalizeName(absClassName);
        this.generatedClasses.put(absClassName, file);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Assert.check((!name.contains("/") ? 1 : 0) != 0);
        Assert.check((!name.contains("\\") ? 1 : 0) != 0);
        JavaClassFileObject file = this.generatedClasses.get(name);
        if (file != null) {
            byte[] byteCode = file.getByteCodeArray();
            return this.defineClass(name, byteCode, 0, byteCode.length);
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(name);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            int extLength = JavaFileObject.Kind.CLASS.extension.length();
            String className = name.substring(0, name.length() - extLength).replace('/', '.');
            JavaClassFileObject file = this.generatedClasses.get(className);
            if (file != null) {
                return file.openInputStream();
            }
        }
        return this.getParent().getResourceAsStream(name);
    }
}

