/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.statements;

import java.util.List;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.common.java.Assert;

public class PlcCommentBlock
extends PlcStatement {
    public final int starCount;
    public final List<String> lines;

    public PlcCommentBlock(List<String> lines) {
        this(10, lines);
    }

    public PlcCommentBlock(int starCount, List<String> lines) {
        this.starCount = starCount;
        this.lines = lines;
        for (String line : lines) {
            Assert.check((!line.contains("(*") ? 1 : 0) != 0);
            Assert.check((!line.contains("*)") ? 1 : 0) != 0);
        }
    }

    @Override
    public PlcStatement copy() {
        return new PlcCommentBlock(this.starCount, this.lines);
    }

    @Override
    public boolean isProperPlcStatement() {
        return false;
    }
}

