/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.builders;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.builders.CombinedEdges;
import org.eclipse.escet.cif.eventbased.builders.State;
import org.eclipse.escet.cif.eventbased.builders.StateEdges;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class EdgeBuilder {
    public Map<Event, CombinedEdges> edgeInfo;
    protected List<CombinedEdges> edgeConstructions;
    protected State state;

    public EdgeBuilder(List<Automaton> automs, Set<Event> events) {
        this.edgeInfo = Maps.mapc((int)events.size());
        this.edgeConstructions = Lists.listc((int)events.size());
        block0: for (Event evt : events) {
            for (Automaton aut : automs) {
                if (!aut.alphabet.contains(evt)) continue;
                CombinedEdges eci = new CombinedEdges(evt, automs);
                this.edgeConstructions.add(eci);
                this.edgeInfo.put(evt, eci);
                continue block0;
            }
        }
    }

    public void setupStateEdges(State state) {
        this.clearEdgeInfo();
        int li = 0;
        while (li < state.locs.length) {
            Location loc = state.locs[li];
            Edge edge = loc.outgoingEdges;
            while (edge != null) {
                CombinedEdges ce = this.edgeInfo.get(edge.event);
                ce.sourceEdges.get(li).add(edge);
                edge = edge.nextOutgoing;
            }
            ++li;
        }
        this.state = state;
    }

    public Iterable<StateEdges> getStateEdges() {
        return new EdgeBuilderIterator();
    }

    protected void clearEdgeInfo() {
        for (CombinedEdges ce : this.edgeInfo.values()) {
            ce.clear();
        }
    }

    private class EdgeBuilderIterator
    implements Iterable<StateEdges>,
    Iterator<StateEdges> {
        private StateEdges res = new StateEdges();
        int next = 0;

        @Override
        public boolean hasNext() {
            return this.next < EdgeBuilder.this.edgeConstructions.size();
        }

        @Override
        public StateEdges next() {
            int index = this.next;
            this.next = index + 1;
            if (index >= EdgeBuilder.this.edgeConstructions.size()) {
                throw new NoSuchElementException();
            }
            CombinedEdges ce = EdgeBuilder.this.edgeConstructions.get(index);
            this.res.event = ce.event;
            this.res.combinedEdges = ce;
            this.res.srcState = EdgeBuilder.this.state;
            return this.res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<StateEdges> iterator() {
            return this;
        }
    }
}

