/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.escet.cif.typechecker.SourceFile;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class SourceFiles {
    private final Queue<SourceFile> queue = new ArrayDeque<SourceFile>();
    private final Map<String, SourceFile> filesMap = Maps.mapc((int)1);

    public SourceFile get(String absPath) {
        return this.filesMap.get(absPath);
    }

    public void add(SourceFile sourceFile) {
        this.queue.add(sourceFile);
        SourceFile previousFile = this.filesMap.put(sourceFile.absPath, sourceFile);
        Assert.check((previousFile == null ? 1 : 0) != 0);
    }

    public void remove(SourceFile sourceFile) {
        this.queue.remove(sourceFile);
        SourceFile previousFile = this.filesMap.remove(sourceFile.absPath);
        Assert.check((previousFile == sourceFile ? 1 : 0) != 0);
    }

    public List<SourceFile> drainQueue() {
        List rslt = Lists.listc((int)this.queue.size());
        for (SourceFile sourceFile : this.queue) {
            rslt.add(sourceFile);
        }
        this.queue.clear();
        return rslt;
    }
}

