/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen;

import java.util.List;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.java.JavaEnum;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.metamodel.chi.Declaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ProcessTypeDefinition {
    public final TypeID tid;
    public List<ProcessDeclaration> processes;

    public ProcessTypeDefinition(TypeID tid) {
        this.tid = tid;
        this.processes = Lists.list();
    }

    public void generate(CodeGeneratorContext ctxt) {
        JavaEnum javaEnum = new JavaEnum(ctxt.getTypeName(this.tid));
        javaEnum.addValue("PP_NONE");
        for (ProcessDeclaration pd : this.processes) {
            String value = "P_" + pd.getName();
            javaEnum.addValue(value);
        }
        String typedArgs = ctxt.specName + " spec, ChiCoordinator chiCoordinator";
        javaEnum.addImport("org.eclipse.escet.chi.runtime.ChiCoordinator", false);
        Object actualArgs = "spec, chiCoordinator";
        int i = 0;
        while (i < this.tid.subTypes.size()) {
            TypeID subTid = this.tid.subTypes.get(i);
            if (!typedArgs.isEmpty()) {
                typedArgs = typedArgs + ", ";
            }
            if (!((String)actualArgs).isEmpty()) {
                actualArgs = (String)actualArgs + ", ";
            }
            typedArgs = typedArgs + subTid.getJavaType() + " arg" + String.valueOf(i);
            actualArgs = (String)actualArgs + "arg" + String.valueOf(i);
            ++i;
        }
        String header = "public BaseProcess create(" + typedArgs + ")";
        JavaMethod jm = new JavaMethod(header);
        javaEnum.addImport("org.eclipse.escet.chi.runtime.data.BaseProcess", false);
        jm.lines.add("switch (this) {");
        jm.lines.indent();
        for (ProcessDeclaration pd : this.processes) {
            jm.lines.add("case P_%s: return new %s(%s);", new Object[]{pd.getName(), ctxt.getDefinition((PositionObject)pd), actualArgs});
        }
        jm.lines.dedent();
        jm.lines.add("}");
        jm.lines.add("throw new ChiSimulatorException(\"Process variable not initialized.\");");
        javaEnum.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        javaEnum.addMethod(jm);
        ctxt.addClass(javaEnum);
    }

    public void addProcess(ProcessDeclaration pd) {
        this.processes.add(pd);
    }

    public static void addProcessTypes(List<Declaration> decls, JavaFile specClass, CodeGeneratorContext ctxt) {
        for (Declaration decl : decls) {
            if (!(decl instanceof ProcessDeclaration)) continue;
            ProcessDeclaration pd = (ProcessDeclaration)decl;
            ctxt.addProcessDefinition(pd);
        }
    }
}

