/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class JavaCodeUtils {
    public static final Set<String> JAVA_IDS = Sets.set(new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "_", "exports", "module", "non-sealed", "open", "opens", "permits", "provides", "record", "requires", "sealed", "to", "transitive", "uses", "var", "when", "with", "yield", "false", "null", "true"});

    private JavaCodeUtils() {
    }

    public static String makeJavaName(String name) {
        if (!JAVA_IDS.contains(name)) {
            return name;
        }
        return "_" + name;
    }

    public static List<String> formatImports(Collection<String> imports, String pkg) {
        List staticImports = Lists.list();
        List otherImports = Lists.list();
        for (String imp : imports) {
            if (imp.startsWith("static ")) {
                staticImports.add(imp);
                continue;
            }
            otherImports.add(imp);
        }
        Collections.sort(staticImports);
        Collections.sort(otherImports);
        List<String> rslt = Lists.list();
        String lastImportStart = null;
        for (String imp : Lists.concat(staticImports, otherImports)) {
            if (imp.startsWith("java.lang.") && StringUtils.countMatches((CharSequence)imp, (CharSequence)".") == 2 || imp.equals("boolean") || imp.equals("byte") || imp.equals("char") || imp.equals("short") || imp.equals("int") || imp.equals("long") || imp.equals("float") || imp.equals("double")) continue;
            if (pkg != null) {
                String impPkg;
                int idx = imp.lastIndexOf(46);
                Assert.check(idx != 0);
                String string = impPkg = idx < 0 ? "" : Strings.slice(imp, 0, idx);
                if (impPkg.equals(pkg)) continue;
            }
            if (lastImportStart != null && !imp.startsWith(lastImportStart)) {
                rslt.add("");
            }
            lastImportStart = Strings.slice(imp, 0, 1);
            rslt.add(Strings.fmt("import %s;", imp));
        }
        return rslt;
    }
}

