/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class CifEventTransition {
    public final Event event;
    public final List<TransitionAutomaton> senders;
    public final List<TransitionAutomaton> receivers;
    public final List<TransitionAutomaton> syncers;
    public final List<TransitionAutomaton> monitors;

    public CifEventTransition(Event event) {
        this(event, Lists.list(), Lists.list(), Lists.list(), Lists.list());
    }

    public CifEventTransition(Event event, List<TransitionAutomaton> senders, List<TransitionAutomaton> receivers, List<TransitionAutomaton> syncers, List<TransitionAutomaton> monitors) {
        this.event = event;
        this.senders = senders;
        this.receivers = receivers;
        this.syncers = syncers;
        this.monitors = monitors;
    }

    public Set<Declaration> collectAssignedVariables() {
        Set assignedVariables = Sets.set();
        for (TransitionAutomaton sender : this.senders) {
            sender.collectAssignedVariables(assignedVariables);
        }
        for (TransitionAutomaton receiver : this.receivers) {
            receiver.collectAssignedVariables(assignedVariables);
        }
        for (TransitionAutomaton syncer : this.syncers) {
            syncer.collectAssignedVariables(assignedVariables);
        }
        for (TransitionAutomaton monitor : this.monitors) {
            monitor.collectAssignedVariables(assignedVariables);
        }
        return assignedVariables;
    }

    public static enum TransAutPurpose {
        SENDER("provide a value for the channel"),
        RECEIVER("accept a value from the channel"),
        SYNCER("synchronize"),
        MONITOR("optionally synchronize");

        public final String purposeText;

        private TransAutPurpose(String purposeText) {
            this.purposeText = purposeText;
        }
    }

    public static class TransitionAutomaton {
        public final Automaton aut;
        public final TransAutPurpose purpose;
        public final List<TransitionEdge> transitionEdges;

        public TransitionAutomaton(Automaton aut, TransAutPurpose purpose, List<TransitionEdge> transitionEdges) {
            this.aut = aut;
            this.purpose = purpose;
            this.transitionEdges = transitionEdges;
        }

        public void collectAssignedVariables(Set<Declaration> assignedVariables) {
            for (TransitionEdge transEdge : this.transitionEdges) {
                CifAddressableUtils.collectAddrVars(transEdge.updates, assignedVariables);
            }
        }

        public boolean hasGuards() {
            return this.transitionEdges.stream().anyMatch(te -> te.hasGuards());
        }

        public boolean hasUpdates() {
            return this.transitionEdges.stream().anyMatch(te -> te.hasUpdates());
        }
    }

    public static class TransitionEdge {
        public final Edge edge;
        public final int edgeNumber;
        public final Location sourceLoc;
        public final Location targetLoc;
        public final Expression sendValue;
        public final List<Expression> guards;
        public final List<Update> updates;

        public TransitionEdge(Edge edge, int edgeNumber, Location sourceLoc, Location targetLoc, Expression sendValue, List<Expression> guards, List<Update> updates) {
            this.edge = edge;
            this.edgeNumber = edgeNumber;
            this.sourceLoc = sourceLoc;
            this.targetLoc = targetLoc;
            this.sendValue = sendValue;
            this.guards = guards;
            this.updates = updates;
        }

        public boolean hasGuards() {
            return !this.guards.isEmpty();
        }

        public boolean hasUpdates() {
            return !this.updates.isEmpty();
        }
    }
}

