/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.clustering;

import java.util.BitSet;
import java.util.List;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.multilevel.ciftodmm.CifRelations;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Lists;

public class TreeNode {
    public final BitSet plantGroups;
    public final BitSet requirementGroups;
    public final List<TreeNode> childNodes = Lists.list();
    public String hierarchicalName = null;
    public Specification partialSpec = null;
    public long numDbsViolations = 0L;
    public boolean dbsCheckIsComplete;
    public List<String> dbsPrecheckerReportLines = null;

    public TreeNode() {
        this(new BitSet(), new BitSet());
    }

    public TreeNode(BitSet plantGroups, BitSet requirementGroups) {
        this.plantGroups = plantGroups;
        this.requirementGroups = requirementGroups;
    }

    public List<TreeNode> linearizeTree() {
        return TreeNode.linearizeTree(this, "partialSpec", Lists.list());
    }

    private static List<TreeNode> linearizeTree(TreeNode node, String hierarchicalName, List<TreeNode> nodes) {
        node.hierarchicalName = hierarchicalName;
        nodes.add(node);
        int index = 1;
        for (TreeNode child : node.childNodes) {
            TreeNode.linearizeTree(child, hierarchicalName + "_" + index, nodes);
            ++index;
        }
        return nodes;
    }

    public CodeBox toBox(CifRelations cifRelations) {
        MemoryCodeBox box = new MemoryCodeBox();
        box.add("Partial specification \"%s.cif\":", new Object[]{this.hierarchicalName});
        box.indent();
        box.add("Plants:");
        box.indent();
        if (this.plantGroups.isEmpty()) {
            box.add("None.");
        } else {
            for (String plantName : cifRelations.getSortedPlantNames(this.plantGroups)) {
                box.add("- Plant \"%s\".", new Object[]{plantName});
            }
        }
        box.dedent();
        box.add();
        box.add("Requirements:");
        box.indent();
        if (this.requirementGroups.isEmpty()) {
            box.add("None.");
        } else {
            for (String reqName : cifRelations.getSortedRequirementNames(this.requirementGroups)) {
                box.add("- Requirement \"%s\".", new Object[]{reqName});
            }
        }
        box.dedent();
        box.add();
        box.add("Children of the partial specification:");
        box.indent();
        if (this.childNodes.isEmpty()) {
            box.add("None.");
        } else {
            for (TreeNode child : this.childNodes) {
                box.add("- Partial specification \"%s.cif\".", new Object[]{child.hierarchicalName});
            }
        }
        box.dedent();
        return box;
    }
}

