/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.orderers;

import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.bdd.varorder.helper.RelationsKind;
import org.eclipse.escet.cif.bdd.varorder.helper.RepresentationKind;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.bdd.varorder.metrics.VarOrderMetric;
import org.eclipse.escet.cif.bdd.varorder.metrics.VarOrderMetricKind;
import org.eclipse.escet.cif.bdd.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class ChoiceVarOrderer
extends VarOrderer {
    private final String name;
    private final List<VarOrderer> choices;
    private final VarOrderMetricKind metricKind;
    private final RelationsKind relationsKind;
    private final VarOrdererEffect effect;

    public ChoiceVarOrderer(List<VarOrderer> choices, VarOrderMetricKind metricKind, RelationsKind relationsKind, VarOrdererEffect effect) {
        this(null, choices, metricKind, relationsKind, effect);
    }

    public ChoiceVarOrderer(String name, List<VarOrderer> choices, VarOrderMetricKind metricKind, RelationsKind relationsKind, VarOrdererEffect effect) {
        this.name = name;
        this.choices = choices;
        this.metricKind = metricKind;
        this.relationsKind = relationsKind;
        this.effect = effect;
        Assert.check((choices.size() >= 2 ? 1 : 0) != 0);
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        List<BitSet> hyperEdges;
        if (dbgEnabled) {
            if (this.name == null) {
                inputData.helper.dbg(dbgLevel, "Applying multiple orderers, and choosing the best result:", new Object[0]);
            } else {
                inputData.helper.dbg(dbgLevel, "Applying %s:", this.name);
            }
            inputData.helper.dbg(dbgLevel + 1, "Metric: %s", this.enumValueToParserArg(this.metricKind));
            inputData.helper.dbg(dbgLevel + 1, "Relations: %s", this.enumValueToParserArg(this.relationsKind));
            inputData.helper.dbg(dbgLevel + 1, "Effect: %s", this.enumValueToParserArg(this.effect));
            inputData.helper.dbgRepresentation(dbgLevel + 1, RepresentationKind.HYPER_EDGES, this.relationsKind);
            inputData.helper.dbg();
        }
        if ((hyperEdges = inputData.helper.getHyperEdges(this.relationsKind)).isEmpty()) {
            if (dbgEnabled) {
                inputData.helper.dbg(dbgLevel + 1, "Skipping orderer%s: no hyper-edges.", this.name == null ? "s" : "");
            }
            return inputData;
        }
        VarOrdererData bestData = null;
        double bestMetric = Double.POSITIVE_INFINITY;
        VarOrderMetric metric = this.metricKind.create();
        int i = 0;
        while (i < this.choices.size()) {
            if (i > 0 && dbgEnabled) {
                inputData.helper.dbg();
            }
            VarOrderer choice = this.choices.get(i);
            VarOrdererData choiceData = choice.order(inputData, dbgEnabled, dbgLevel + 1);
            double choiceMetric = metric.computeForVarOrder(inputData.helper, choiceData.varOrder.getOrderedVars(), hyperEdges);
            if (choiceMetric < bestMetric) {
                bestData = choiceData;
                bestMetric = choiceMetric;
                if (dbgEnabled) {
                    inputData.helper.dbg();
                    inputData.helper.dbg(dbgLevel + 1, "Found new best variable order.", new Object[0]);
                }
            }
            ++i;
        }
        if (bestData == null) {
            throw new AssertionError();
        }
        return new VarOrdererData(inputData, bestData.varOrder, this.effect);
    }

    public String toString() {
        return Strings.fmt((String)"or(metric=%s, relations=%s, effect=%s, choices=[%s])", (Object[])new Object[]{this.enumValueToParserArg(this.metricKind), this.enumValueToParserArg(this.relationsKind), this.enumValueToParserArg(this.effect), this.choices.stream().map(Object::toString).collect(Collectors.joining(", "))});
    }
}

