/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.math.BigInteger;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class BigIntegerOption
extends Option<BigInteger> {
    protected final boolean hasSpecialValue;
    protected final BigInteger defaultValue;
    protected final BigInteger defaultNormalValue;
    protected final BigInteger minimumValue;
    protected final BigInteger maximumValue;
    protected final String specialValueSyntax;
    protected final String optDialogDescr;
    protected final String optDialogSpecialText;
    protected final String optDialogNormalText;
    protected final String optDialogLabelText;

    public BigIntegerOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, BigInteger defaultValue, BigInteger minimumValue, BigInteger maximumValue, boolean showInDialog, String optDialogDescr, String optDialogLabelText) {
        this(name, description, cmdShort, cmdLong, cmdValue, defaultValue, minimumValue, maximumValue, showInDialog, optDialogDescr, optDialogLabelText, false, null, null, null, null);
    }

    public BigIntegerOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, BigInteger defaultValue, BigInteger minimumValue, BigInteger maximumValue, boolean showInDialog, String optDialogDescr, String optDialogLabelText, boolean hasSpecialValue, BigInteger defaultNormalValue, String specialValueSyntax, String optDialogSpecialText, String optDialogNormalText) {
        super(name, description, cmdShort, cmdLong, cmdValue, showInDialog);
        Assert.notNull((Object)cmdLong);
        Assert.check((!cmdLong.equals("*") ? 1 : 0) != 0);
        Assert.notNull((Object)cmdValue);
        Assert.implies((defaultValue == null ? 1 : 0) != 0, (boolean)hasSpecialValue);
        if (defaultValue != null) {
            if (minimumValue != null) {
                Assert.check((minimumValue.compareTo(defaultValue) <= 0 ? 1 : 0) != 0);
            }
            if (maximumValue != null) {
                Assert.check((defaultValue.compareTo(maximumValue) <= 0 ? 1 : 0) != 0);
            }
        }
        Assert.ifAndOnlyIf((!showInDialog || !hasSpecialValue ? 1 : 0) != 0, (defaultNormalValue == null ? 1 : 0) != 0);
        if (defaultNormalValue != null) {
            if (minimumValue != null) {
                Assert.check((minimumValue.compareTo(defaultNormalValue) <= 0 ? 1 : 0) != 0);
            }
            if (maximumValue != null) {
                Assert.check((defaultNormalValue.compareTo(maximumValue) <= 0 ? 1 : 0) != 0);
            }
        }
        Assert.ifAndOnlyIf((boolean)showInDialog, (optDialogDescr != null ? 1 : 0) != 0);
        Assert.implies((!showInDialog ? 1 : 0) != 0, (optDialogLabelText == null ? 1 : 0) != 0);
        if (optDialogLabelText != null) {
            Assert.check((boolean)optDialogLabelText.endsWith(":"));
        }
        Assert.ifAndOnlyIf((boolean)hasSpecialValue, (specialValueSyntax != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((hasSpecialValue && showInDialog ? 1 : 0) != 0, (optDialogSpecialText != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((hasSpecialValue && showInDialog ? 1 : 0) != 0, (optDialogNormalText != null ? 1 : 0) != 0);
        this.defaultValue = defaultValue;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.optDialogDescr = optDialogDescr;
        this.optDialogLabelText = optDialogLabelText;
        this.hasSpecialValue = hasSpecialValue;
        this.defaultNormalValue = defaultNormalValue;
        this.specialValueSyntax = specialValueSyntax;
        this.optDialogSpecialText = optDialogSpecialText;
        this.optDialogNormalText = optDialogNormalText;
    }

    @Override
    public BigInteger getDefault() {
        return this.defaultValue;
    }

    @Override
    public BigInteger parseValue(String optName, String value) {
        BigInteger v;
        if (this.hasSpecialValue && value.equals(this.specialValueSyntax)) {
            return null;
        }
        try {
            v = new BigInteger(value);
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Invalid integer number \"%s\".", (Object[])new Object[]{value});
            throw new InvalidOptionException(msg);
        }
        if (this.minimumValue != null) {
            BigIntegerOption.checkValue(v.compareTo(this.minimumValue) >= 0, String.valueOf(v) + " < " + String.valueOf(this.minimumValue));
        }
        if (this.maximumValue != null) {
            BigIntegerOption.checkValue(v.compareTo(this.maximumValue) <= 0, String.valueOf(v) + " > " + String.valueOf(this.maximumValue));
        }
        return v;
    }

    @Override
    public String[] getCmdLine(Object value) {
        if (value == null) {
            Assert.check((boolean)this.hasSpecialValue);
            return new String[]{"--" + this.cmdLong + "=" + this.specialValueSyntax};
        }
        return new String[]{"--" + this.cmdLong + "=" + String.valueOf(value)};
    }

    @Override
    public OptionGroup<BigInteger> createOptionGroup(Composite page) {
        Assert.check((boolean)this.showInDialog);
        return new BigIntegerOptionGroup(page);
    }

    private class BigIntegerOptionGroup
    extends OptionGroup<BigInteger>
    implements SelectionListener {
        private Button specialButton;
        private Button normalButton;
        Label valueLabel;
        Text valueText;

        public BigIntegerOptionGroup(Composite page) {
            super(page, BigIntegerOption.this);
        }

        @Override
        protected void addComponents(Group group) {
            Object[] valueLayout;
            if (BigIntegerOption.this.hasSpecialValue) {
                this.specialButton = new Button((Composite)group, 16);
                this.specialButton.setText(BigIntegerOption.this.optDialogSpecialText);
                this.normalButton = new Button((Composite)group, 16);
                this.normalButton.setText(BigIntegerOption.this.optDialogNormalText);
                this.specialButton.addSelectionListener((SelectionListener)this);
                this.normalButton.addSelectionListener((SelectionListener)this);
            }
            this.valueText = new Text((Composite)group, 2048);
            String defaultText = (BigIntegerOption.this.defaultValue == null ? BigIntegerOption.this.defaultNormalValue : BigIntegerOption.this.defaultValue).toString();
            this.valueText.setText(defaultText);
            if (BigIntegerOption.this.optDialogLabelText == null) {
                valueLayout = new Control[]{this.valueText};
            } else {
                this.valueLabel = new Label((Composite)group, 0);
                this.valueLabel.setText(BigIntegerOption.this.optDialogLabelText);
                valueLayout = new Control[]{this.valueLabel, this.valueText};
            }
            Object[] layout = BigIntegerOption.this.hasSpecialValue ? new Object[]{this.specialButton, this.normalButton, valueLayout} : (BigIntegerOption.this.optDialogLabelText == null ? valueLayout : new Object[]{valueLayout});
            this.layoutGeneric(layout, BigIntegerOption.this.hasSpecialValue ? 32 : 0);
        }

        @Override
        public String getDescription() {
            return BigIntegerOption.this.optDialogDescr;
        }

        @Override
        public void setToValue(BigInteger value) {
            if (value == null) {
                Assert.check((boolean)BigIntegerOption.this.hasSpecialValue);
                this.specialButton.setSelection(true);
                Event event = new Event();
                event.widget = this.specialButton;
                this.widgetSelected(new SelectionEvent(event));
                value = BigIntegerOption.this.defaultNormalValue;
            } else if (BigIntegerOption.this.hasSpecialValue) {
                this.normalButton.setSelection(true);
                Event event = new Event();
                event.widget = this.normalButton;
                this.widgetSelected(new SelectionEvent(event));
            }
            this.valueText.setText(value.toString());
        }

        @Override
        public String[] getCmdLine() {
            if (BigIntegerOption.this.hasSpecialValue && this.specialButton.getSelection()) {
                return new String[]{"--" + BigIntegerOption.this.cmdLong + "=" + BigIntegerOption.this.specialValueSyntax};
            }
            return new String[]{"--" + BigIntegerOption.this.cmdLong + "=" + this.valueText.getText()};
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.specialButton) {
                this.valueText.setEnabled(false);
            } else if (e.widget == this.normalButton) {
                this.valueText.setEnabled(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

