/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;

public class CifFormatPatternCodeGenerator {
    private CifFormatPatternCodeGenerator() {
    }

    public static ExprCodeGeneratorResult gencodePattern(String pattern, List<ExprCodeGeneratorResult> valueRslts, List<CifType> valueTypes, Expression expr, CifCompilerContext ctxt) {
        FormatDecoder decoder = new FormatDecoder();
        List parts = decoder.decode(pattern);
        StringBuilder patternCode = new StringBuilder();
        List argCodes = Lists.listc((int)parts.size());
        int implicitIndex = 0;
        Map argIdxToConvertCode = Maps.map();
        List argRslts = Lists.listc((int)valueRslts.size());
        for (FormatDescription part : parts) {
            ExprCodeGeneratorResult rslt;
            if (part.conversion == FormatDescription.Conversion.LITERAL) {
                if (part.text.equals("%")) {
                    patternCode.append("%%%%");
                    continue;
                }
                patternCode.append(part.text);
                continue;
            }
            int idx = !part.index.isEmpty() ? part.getExplicitIndex() - 1 : implicitIndex++;
            switch (part.conversion) {
                case BOOLEAN: 
                case INTEGER: 
                case REAL: {
                    patternCode.append(part.toString(false).replace("%", "%%"));
                    argCodes.add("%s");
                    rslt = valueRslts.get(idx);
                    break;
                }
                case STRING: {
                    patternCode.append(part.toString(false).replace("%", "%%"));
                    argCodes.add("%s");
                    CifType t = valueTypes.get(idx);
                    CifType nt = CifTypeUtils.normalizeType((CifType)t);
                    if (!(nt instanceof StringType)) {
                        rslt = (ExprCodeGeneratorResult)argIdxToConvertCode.get(idx);
                        if (rslt != null) break;
                        ExprCodeGeneratorResult valueRslt = valueRslts.get(idx);
                        rslt = ExprCodeGeneratorResult.merge("runtimeToString(%s)", (CifType)CifConstructors.newStringType(), ctxt, valueRslt);
                        argIdxToConvertCode.put(idx, rslt);
                        break;
                    }
                    rslt = valueRslts.get(idx);
                    break;
                }
                default: {
                    String msg = "Unexpected: " + String.valueOf(part.conversion);
                    throw new RuntimeException(msg);
                }
            }
            argRslts.add(rslt);
        }
        StringBuilder rslt = new StringBuilder();
        rslt.append("fmt(");
        rslt.append(Strings.stringToJava((String)patternCode.toString()));
        if (!argCodes.isEmpty()) {
            rslt.append(", ");
        }
        rslt.append(String.join((CharSequence)", ", argCodes));
        rslt.append(")");
        return ExprCodeGeneratorResult.merge(rslt.toString(), expr.getType(), ctxt, argRslts);
    }
}

