/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import org.eclipse.escet.common.java.Strings;

public class Stopwatch {
    private long duration = 0L;
    private long startNano = -1L;
    private boolean running = false;
    private boolean measured = false;

    public boolean isRunning() {
        return this.running;
    }

    public boolean hasMeasured() {
        return this.measured;
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("Stopwatch is already running.");
        }
        this.startNano = System.nanoTime();
        this.running = true;
        this.measured = true;
    }

    public void stop() {
        if (!this.running) {
            throw new IllegalStateException("Stopwatch is not running.");
        }
        this.duration += System.nanoTime() - this.startNano;
        this.startNano = -1L;
        this.running = false;
    }

    public void reset() {
        this.duration = 0L;
        if (this.running) {
            this.startNano = System.nanoTime();
        } else {
            this.measured = false;
        }
    }

    public long getDurationNanos() {
        long total = this.duration;
        if (this.running) {
            total += System.nanoTime() - this.startNano;
        }
        return total;
    }

    public double getDurationMicros() {
        return (double)this.getDurationNanos() / 1000.0;
    }

    public double getDurationMillis() {
        return (double)this.getDurationNanos() / 1000000.0;
    }

    public double getDurationSecs() {
        return (double)this.getDurationNanos() / 1.0E9;
    }

    public String toString() {
        return Strings.fmt("%d ns = %,.0f us = %,.0f ms = %,.0f s", this.getDurationNanos(), this.getDurationMicros(), this.getDurationMillis(), this.getDurationSecs());
    }
}

