/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Objects;
import org.eclipse.escet.common.java.Strings;

public class Pair<T1, T2> {
    public final T1 left;
    public final T2 right;

    public Pair(T1 left, T2 right) {
        this.left = left;
        this.right = right;
    }

    public static <TL, TR> Pair<TL, TR> pair(TL left, TR right) {
        return new Pair<TL, TR>(left, right);
    }

    public int hashCode() {
        long leftHash = Objects.hashCode(this.left);
        long rightHash = Objects.hashCode(this.right);
        long low = leftHash * rightHash;
        long high = Math.unsignedMultiplyHigh(leftHash, rightHash);
        long hash = (leftHash ^= low) ^ (rightHash ^= high);
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    public String toString() {
        return Strings.fmt("(%s, %s)", this.left, this.right);
    }
}

