/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.bitvectors;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import java.math.BigInteger;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.BddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.SignedBddBitVectorAndCarry;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedBddBitVector;
import org.eclipse.escet.cif.bdd.spec.CifBddDomain;
import org.eclipse.escet.common.java.Assert;

public class SignedBddBitVector
extends BddBitVector<SignedBddBitVector, SignedBddBitVectorAndCarry> {
    public static final int MINIMUM_LENGTH = 2;

    private SignedBddBitVector(BDDFactory factory, int length) {
        super(factory, length);
    }

    @Override
    protected int getMinimumLength() {
        return 2;
    }

    public static int getMinimumLength(int value) {
        if (value >= 0) {
            return Math.max(2, 1 + UnsignedBddBitVector.getMinimumLength(value));
        }
        return Math.max(2, 1 + UnsignedBddBitVector.getMinimumLength(-(value + 1)));
    }

    @Override
    protected SignedBddBitVector createEmpty(int length) {
        return new SignedBddBitVector(this.factory, length);
    }

    public static SignedBddBitVector create(BDDFactory factory, int length) {
        return SignedBddBitVector.create(factory, length, false);
    }

    public static SignedBddBitVector create(BDDFactory factory, int length, boolean value) {
        SignedBddBitVector vector = new SignedBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = value ? factory.one() : factory.zero();
            ++i;
        }
        return vector;
    }

    public static SignedBddBitVector createFromInt(BDDFactory factory, int value) {
        int length = SignedBddBitVector.getMinimumLength(value);
        return SignedBddBitVector.createFromInt(factory, length, value);
    }

    public static SignedBddBitVector createFromInt(BDDFactory factory, int length, int value) {
        if (length < SignedBddBitVector.getMinimumLength(value)) {
            throw new IllegalArgumentException("Length is insufficient.");
        }
        SignedBddBitVector vector = new SignedBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = (value & 1) != 0 ? factory.one() : factory.zero();
            value >>= 1;
            ++i;
        }
        Assert.check((value == 0 || value == -1 ? 1 : 0) != 0, (Object)value);
        return vector;
    }

    public static SignedBddBitVector createFromDomain(CifBddDomain domain) {
        int varCnt = domain.getVarCount();
        SignedBddBitVector vector = new SignedBddBitVector(domain.getFactory(), varCnt);
        int[] vars = domain.getVarIndices();
        int i = 0;
        while (i < vars.length) {
            vector.bits[i] = vector.factory.ithVar(vars[i]);
            ++i;
        }
        return vector;
    }

    public static SignedBddBitVector createFromUnsignedBitVector(UnsignedBddBitVector unsignedVector) {
        SignedBddBitVector signedVector = new SignedBddBitVector(unsignedVector.factory, unsignedVector.length() + 1);
        int i = 0;
        while (i < unsignedVector.length()) {
            signedVector.bits[i] = unsignedVector.getBit(i).id();
            ++i;
        }
        signedVector.bits[signedVector.bits.length - 1] = signedVector.factory.zero();
        return signedVector;
    }

    @Override
    public BigInteger getLower() {
        return BigInteger.TWO.pow(this.bits.length - 1).negate();
    }

    @Override
    public int getLowerInt() {
        return this.getLower().intValueExact();
    }

    @Override
    public BigInteger getUpper() {
        return BigInteger.TWO.pow(this.bits.length - 1).subtract(BigInteger.ONE);
    }

    @Override
    public int getUpperInt() {
        return this.getUpper().intValueExact();
    }

    @Override
    public Integer getInt() {
        if (this.bits.length > 32) {
            throw new IllegalStateException("More than 32 bits in vector.");
        }
        Long value = this.getLong();
        return value == null ? null : Integer.valueOf((int)value.longValue());
    }

    @Override
    public Long getLong() {
        long value;
        if (this.bits.length > 64) {
            throw new IllegalStateException("More than 64 bits in vector.");
        }
        int bitIndex = this.bits.length - 1;
        if (this.bits[bitIndex].isOne()) {
            value = -1L;
        } else if (this.bits[bitIndex].isZero()) {
            value = 0L;
        } else {
            return null;
        }
        --bitIndex;
        while (bitIndex >= 0) {
            if (this.bits[bitIndex].isOne()) {
                value = value << 1 | 1L;
            } else if (this.bits[bitIndex].isZero()) {
                value <<= 1;
            } else {
                return null;
            }
            --bitIndex;
        }
        return value;
    }

    @Override
    public void setInt(int value) {
        if (this.bits.length < SignedBddBitVector.getMinimumLength(value)) {
            throw new IllegalArgumentException("Length is insufficient.");
        }
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = (value & 1) != 0 ? this.factory.one() : this.factory.zero();
            value >>= 1;
            ++i;
        }
        Assert.check((value == 0 || value == -1 ? 1 : 0) != 0, (Object)value);
    }

    @Override
    public void resize(int length) {
        if (length == this.bits.length) {
            return;
        }
        if (length < 2) {
            throw new IllegalArgumentException("Length is less than two.");
        }
        BDD[] newBits = new BDD[length];
        int numberOfCommonBits = Math.min(this.bits.length, length);
        System.arraycopy(this.bits, 0, newBits, 0, numberOfCommonBits);
        BDD signBit = this.bits[this.bits.length - 1];
        int i = numberOfCommonBits;
        while (i < length) {
            newBits[i] = signBit.id();
            ++i;
        }
        i = numberOfCommonBits;
        while (i < this.bits.length) {
            this.bits[i].free();
            ++i;
        }
        this.bits = newBits;
    }

    @Override
    public SignedBddBitVector shrink() {
        int length = this.bits.length;
        while (length > 2 && this.bits[length - 1].equalsBDD(this.bits[length - 2])) {
            --length;
        }
        this.resize(length);
        return this;
    }

    @Override
    public SignedBddBitVectorAndCarry negate() {
        SignedBddBitVector rslt = new SignedBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.one();
        BDD lastCarry = this.factory.zero();
        BDD beforeLastCarry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            BDD notThisI = this.bits[i].not();
            rslt.bits[i] = notThisI.id().xorWith(carry.id());
            carry = carry.andWith(notThisI);
            if (i == this.bits.length - 1) {
                lastCarry = carry.id();
            } else if (i == this.bits.length - 2) {
                beforeLastCarry = carry.id();
            }
            ++i;
        }
        carry.free();
        carry = beforeLastCarry.xorWith(lastCarry);
        return new SignedBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public SignedBddBitVectorAndCarry abs() {
        BDD cmp = this.bits[this.bits.length - 1];
        SignedBddBitVectorAndCarry negated = this.negate();
        BDD overflow = negated.carry;
        SignedBddBitVector resultVector = SignedBddBitVector.ifThenElse(cmp, (SignedBddBitVector)negated.vector, this);
        ((SignedBddBitVector)negated.vector).free();
        return new SignedBddBitVectorAndCarry(resultVector, overflow);
    }

    @Override
    public SignedBddBitVector sign() {
        BDD isNeg = this.bits[this.bits.length - 1];
        BDD isZero = this.factory.one();
        BDD[] bDDArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            BDD bit = bDDArray[n2];
            isZero = isZero.andWith(bit.not());
            ++n2;
        }
        SignedBddBitVector negOne = SignedBddBitVector.createFromInt(this.factory, 2, -1);
        SignedBddBitVector zero = SignedBddBitVector.createFromInt(this.factory, 2, 0);
        SignedBddBitVector posOne = SignedBddBitVector.createFromInt(this.factory, 2, 1);
        SignedBddBitVector elifResult = SignedBddBitVector.ifThenElse(isZero, zero, posOne);
        SignedBddBitVector result = SignedBddBitVector.ifThenElse(isNeg, negOne, elifResult);
        isZero.free();
        negOne.free();
        zero.free();
        posOne.free();
        elifResult.free();
        return result;
    }

    @Override
    public SignedBddBitVectorAndCarry add(SignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        SignedBddBitVector rslt = new SignedBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        BDD lastCarry = this.factory.zero();
        BDD beforeLastCarry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            carry = this.bits[i].and(other.bits[i]).orWith(carry.andWith(this.bits[i].or(other.bits[i])));
            if (i == this.bits.length - 1) {
                lastCarry = carry.id();
            } else if (i == this.bits.length - 2) {
                beforeLastCarry = carry.id();
            }
            ++i;
        }
        carry.free();
        carry = beforeLastCarry.xorWith(lastCarry);
        return new SignedBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public SignedBddBitVectorAndCarry subtract(SignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        SignedBddBitVector rslt = new SignedBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        BDD lastCarry = this.factory.zero();
        BDD beforeLastCarry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            BDD tmp1 = other.bits[i].or(carry);
            BDD tmp2 = this.bits[i].apply(tmp1, BDDFactory.less);
            tmp1.free();
            carry = this.bits[i].and(other.bits[i]).andWith(carry).orWith(tmp2);
            if (i == this.bits.length - 1) {
                lastCarry = carry.id();
            } else if (i == this.bits.length - 2) {
                beforeLastCarry = carry.id();
            }
            ++i;
        }
        carry.free();
        carry = beforeLastCarry.xorWith(lastCarry);
        return new SignedBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public SignedBddBitVectorAndCarry multiply(SignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        int length = this.bits.length;
        int doubleLength = length * 2;
        SignedBddBitVector left = (SignedBddBitVector)this.copy();
        SignedBddBitVector right = (SignedBddBitVector)other.copy();
        left.resize(doubleLength);
        right.resize(doubleLength);
        SignedBddBitVector result = SignedBddBitVector.create(this.factory, doubleLength, false);
        int i = 0;
        while (i < doubleLength) {
            SignedBddBitVectorAndCarry added = result.add(left);
            int j = 0;
            while (j < doubleLength) {
                BDD bit = result.bits[j];
                result.bits[j] = right.bits[i].ite(((SignedBddBitVector)added.vector).bits[j], bit);
                bit.free();
                ++j;
            }
            ((SignedBddBitVector)added.vector).free();
            added.carry.free();
            SignedBddBitVector oldLeft = left;
            left = (SignedBddBitVector)left.shiftLeft(1, this.factory.zero());
            oldLeft.free();
            ++i;
        }
        left.free();
        right.free();
        BDD signBit = result.bits[length - 1];
        BDD overflow = this.factory.zero();
        int i2 = length;
        while (i2 < doubleLength) {
            overflow = overflow.orWith(result.bits[i2].xor(signBit));
            ++i2;
        }
        result.resize(length);
        return new SignedBddBitVectorAndCarry(result, overflow);
    }

    @Override
    public SignedBddBitVector div(int divisor) {
        return this.divmod(divisor, true);
    }

    @Override
    public SignedBddBitVector mod(int divisor) {
        return this.divmod(divisor, false);
    }

    private SignedBddBitVector divmod(int divisor, boolean isDiv) {
        SignedBddBitVectorAndCarry absThis = this.abs();
        absThis.carry.free();
        SignedBddBitVector resultUnsigned = ((SignedBddBitVector)absThis.vector).divmodUnsigned(divisor, isDiv);
        ((SignedBddBitVector)absThis.vector).free();
        BDD signBit = this.bits[this.bits.length - 1];
        SignedBddBitVectorAndCarry resultUnsignedNeg = resultUnsigned.negate();
        SignedBddBitVector resultSigned = SignedBddBitVector.ifThenElse(signBit, (SignedBddBitVector)resultUnsignedNeg.vector, resultUnsigned);
        resultUnsigned.free();
        ((SignedBddBitVector)resultUnsignedNeg.vector).free();
        resultUnsignedNeg.carry.free();
        return resultSigned;
    }

    private SignedBddBitVector divmodUnsigned(int divisorValue, boolean isDiv) {
        if (divisorValue <= 0) {
            throw new IllegalArgumentException("Divisor is not positive.");
        }
        if (this.bits.length < SignedBddBitVector.getMinimumLength(divisorValue)) {
            throw new IllegalArgumentException("Divisor doesn't fit.");
        }
        SignedBddBitVector divisor = SignedBddBitVector.createFromInt(this.factory, this.bits.length, divisorValue);
        if (!(!isDiv || this.bits[this.bits.length - 1].isZero() || divisor.bits[divisor.length() - 1].isZero() && divisor.bits[divisor.length() - 2].isZero())) {
            throw new IllegalArgumentException("Computing the quotient/'div', the highest bit of the dividend's absolute value is not 'false', and the highest two bits of the divisor are not both 'false'.");
        }
        if (!isDiv && !this.bits[this.bits.length - 1].isZero()) {
            throw new IllegalStateException("Computing the remainder/'mod', and the highest bit of the dividend's absolute value is not 'false'.");
        }
        SignedBddBitVector quotient = (SignedBddBitVector)this.shiftLeft(1, this.factory.zero());
        SignedBddBitVector remainderZero = SignedBddBitVector.create(this.factory, this.bits.length);
        SignedBddBitVector remainder = (SignedBddBitVector)remainderZero.shiftLeft(1, this.bits[this.bits.length - 1]);
        remainderZero.free();
        this.divModUnsignedRecursive(divisor, quotient, remainder, this.bits.length);
        divisor.free();
        if (isDiv) {
            remainder.free();
            return quotient;
        }
        quotient.free();
        SignedBddBitVector shiftedRemainder = (SignedBddBitVector)remainder.shiftRight(1, this.factory.zero());
        remainder.free();
        return shiftedRemainder;
    }

    private void divModUnsignedRecursive(SignedBddBitVector divisor, SignedBddBitVector quotient, SignedBddBitVector remainder, int step) {
        int divLen = divisor.bits.length;
        BDD isSmaller = divisor.lessOrEqual(remainder);
        SignedBddBitVector newQuotient = (SignedBddBitVector)quotient.shiftLeft(1, isSmaller);
        SignedBddBitVector sub = SignedBddBitVector.create(this.factory, divLen);
        int i = 0;
        while (i < divLen) {
            sub.bits[i] = isSmaller.ite(divisor.bits[i], this.factory.zero());
            ++i;
        }
        SignedBddBitVectorAndCarry tmp = remainder.subtract(sub);
        SignedBddBitVector newRemainder = (SignedBddBitVector)((SignedBddBitVector)tmp.vector).shiftLeft(1, quotient.bits[divLen - 1]);
        if (step > 1) {
            this.divModUnsignedRecursive(divisor, newQuotient, newRemainder, step - 1);
        }
        ((SignedBddBitVector)tmp.vector).free();
        tmp.carry.free();
        sub.free();
        isSmaller.free();
        quotient.replaceBy(newQuotient);
        remainder.replaceBy(newRemainder);
    }

    @Override
    public BDD lessThan(SignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD carry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            carry = lt.orWith(eq.andWith(carry));
            ++i;
        }
        BDD thisSignBit = this.bits[this.bits.length - 1];
        BDD otherSignBit = other.bits[other.bits.length - 1];
        BDD lhs = thisSignBit.id().andWith(otherSignBit.not());
        BDD rhs = thisSignBit.id().orWith(otherSignBit.not()).andWith(carry);
        return lhs.orWith(rhs);
    }

    @Override
    public BDD lessOrEqual(SignedBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD carry = this.factory.one();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            carry = lt.orWith(eq.andWith(carry));
            ++i;
        }
        BDD thisSignBit = this.bits[this.bits.length - 1];
        BDD otherSignBit = other.bits[other.bits.length - 1];
        BDD lhs = thisSignBit.id().andWith(otherSignBit.not());
        BDD rhs = thisSignBit.id().orWith(otherSignBit.not()).andWith(carry);
        return lhs.orWith(rhs);
    }

    @Override
    public SignedBddBitVector min(SignedBddBitVector other) {
        BDD cmp = this.lessOrEqual(other);
        SignedBddBitVector result = SignedBddBitVector.ifThenElse(cmp, this, other);
        cmp.free();
        return result;
    }

    @Override
    public SignedBddBitVector max(SignedBddBitVector other) {
        BDD cmp = this.greaterOrEqual(other);
        SignedBddBitVector result = SignedBddBitVector.ifThenElse(cmp, this, other);
        cmp.free();
        return result;
    }
}

