/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.url;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.Supplier;
import org.eclipse.equinox.plurl.PlurlStreamHandlerBase;
import org.eclipse.osgi.internal.url.NullURLStreamHandlerService;
import org.eclipse.osgi.internal.url.URLStreamHandlerFactoryImpl;
import org.eclipse.osgi.internal.url.URLStreamHandlerSetter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class URLStreamHandlerProxy
extends PlurlStreamHandlerBase {
    private static final URLStreamHandlerService NO_HANDLER = new NullURLStreamHandlerService();
    protected URLStreamHandlerService realHandlerService;
    protected final URLStreamHandlerSetter urlSetter = new URLStreamHandlerSetter(this);
    protected final ServiceTracker<URLStreamHandlerService, LazyURLStreamHandlerService> urlStreamHandlerServiceTracker;

    public URLStreamHandlerProxy(String protocol, final BundleContext context) {
        Filter filter;
        try {
            filter = context.createFilter(String.format("(&(%s=%s)(%s=%s))", "objectClass", "org.osgi.service.url.URLStreamHandlerService", "url.handler.protocol", protocol));
        }
        catch (InvalidSyntaxException e) {
            throw new AssertionError("should never happen!", e);
        }
        this.urlStreamHandlerServiceTracker = new ServiceTracker<URLStreamHandlerService, LazyURLStreamHandlerService>(context, filter, new ServiceTrackerCustomizer<URLStreamHandlerService, LazyURLStreamHandlerService>(){

            @Override
            public LazyURLStreamHandlerService addingService(ServiceReference<URLStreamHandlerService> reference) {
                return new LazyURLStreamHandlerService(context, reference);
            }

            @Override
            public void modifiedService(ServiceReference<URLStreamHandlerService> reference, LazyURLStreamHandlerService service) {
            }

            @Override
            public void removedService(ServiceReference<URLStreamHandlerService> reference, LazyURLStreamHandlerService service) {
                service.dispose();
            }
        });
        URLStreamHandlerFactoryImpl.secureAction.open(this.urlStreamHandlerServiceTracker);
    }

    @Override
    public boolean equals(URL url1, URL url2) {
        return this.getRealHandlerService().equals(url1, url2);
    }

    @Override
    public int getDefaultPort() {
        return this.getRealHandlerService().getDefaultPort();
    }

    @Override
    public InetAddress getHostAddress(URL url) {
        return this.getRealHandlerService().getHostAddress(url);
    }

    @Override
    public int hashCode(URL url) {
        return this.getRealHandlerService().hashCode(url);
    }

    @Override
    public boolean hostsEqual(URL url1, URL url2) {
        return this.getRealHandlerService().hostsEqual(url1, url2);
    }

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        return this.getRealHandlerService().openConnection(url);
    }

    @Override
    protected void parseURL(URL url, String str, int start, int end) {
        this.getRealHandlerService().parseURL(this.urlSetter, url, str, start, end);
    }

    @Override
    public boolean sameFile(URL url1, URL url2) {
        return this.getRealHandlerService().sameFile(url1, url2);
    }

    @Override
    public String toExternalForm(URL url) {
        return this.getRealHandlerService().toExternalForm(url);
    }

    @Override
    public URLConnection openConnection(URL u, Proxy p) throws IOException {
        try {
            URLStreamHandlerService service = this.getRealHandlerService();
            Method openConn = service.getClass().getMethod("openConnection", URL.class, Proxy.class);
            openConn.setAccessible(true);
            return (URLConnection)openConn.invoke((Object)service, u, p);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            throw (RuntimeException)e.getTargetException();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    void setURLInternal(URL u, String proto, String host, int port, String auth, String user, String path, String query, String ref) {
        this.setURL(u, proto, host, port, auth, user, path, query, ref);
    }

    void setURLInternal(URL u, String proto, String host, int port, String file, String ref) {
        this.setURL(u, proto, host, port, file, ref);
    }

    public boolean isActive() {
        return this.urlStreamHandlerServiceTracker.getService() != null;
    }

    public URLStreamHandlerService getRealHandlerService() {
        LazyURLStreamHandlerService service = this.urlStreamHandlerServiceTracker.getService();
        if (service != null) {
            return service.get();
        }
        return NO_HANDLER;
    }

    private static final class LazyURLStreamHandlerService
    implements Supplier<URLStreamHandlerService> {
        private BundleContext bundleContext;
        private ServiceReference<URLStreamHandlerService> reference;
        private URLStreamHandlerService service;
        private boolean disposed;

        LazyURLStreamHandlerService(BundleContext bundleContext, ServiceReference<URLStreamHandlerService> reference) {
            this.bundleContext = bundleContext;
            this.reference = reference;
        }

        synchronized void dispose() {
            this.disposed = true;
            if (this.service != null) {
                this.service = null;
                this.bundleContext.ungetService(this.reference);
            }
        }

        @Override
        public synchronized URLStreamHandlerService get() {
            if (this.service == null && !this.disposed) {
                this.service = URLStreamHandlerFactoryImpl.secureAction.getService(this.reference, this.bundleContext);
            }
            return this.service;
        }
    }
}

