/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter2;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.join.HashProbeTable;
import org.apache.jena.sparql.engine.join.JoinKey;

public abstract class AbstractIterHashJoin
extends QueryIter2 {
    protected long s_countProbe = 0L;
    protected long s_countScan = 0L;
    protected long s_countResults = 0L;
    protected long s_trailerResults = 0L;
    protected final JoinKey joinKey;
    protected final HashProbeTable hashTable;
    private QueryIterator iterStream;
    private Binding rowStream = null;
    private Iterator<Binding> iterCurrent;
    private boolean yielded;
    private Iterator<Binding> iterTail = null;
    Phase state = Phase.INIT;
    private Binding slot = null;

    protected AbstractIterHashJoin(JoinKey joinKey, QueryIterator probeIter, QueryIterator streamIter, ExecutionContext execCxt) {
        super(probeIter, streamIter, execCxt);
        if (joinKey == null) {
            QueryIterPeek pProbe = QueryIterPeek.create(probeIter, execCxt);
            QueryIterPeek pStream = QueryIterPeek.create(streamIter, execCxt);
            Binding bLeft = pProbe.peek();
            Binding bRight = pStream.peek();
            List<Var> varsLeft = Iter.toList(bLeft.vars());
            List<Var> varsRight = Iter.toList(bRight.vars());
            joinKey = JoinKey.createVarKey(varsLeft, varsRight);
            probeIter = pProbe;
            streamIter = pStream;
        }
        this.joinKey = joinKey;
        this.iterStream = streamIter;
        this.hashTable = new HashProbeTable(joinKey);
        this.iterCurrent = null;
        this.buildHashTable(probeIter);
    }

    private void buildHashTable(QueryIterator iter1) {
        this.state = Phase.HASH;
        while (iter1.hasNext()) {
            Binding row1 = (Binding)iter1.next();
            ++this.s_countProbe;
            this.hashTable.put(row1);
        }
        iter1.close();
        this.state = Phase.STREAM;
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        if (this.slot == null) {
            this.slot = this.moveToNextBindingOrNull();
            if (this.slot == null) {
                this.close();
                return false;
            }
        }
        return true;
    }

    @Override
    protected Binding moveToNextBinding() {
        Binding r = this.slot;
        this.slot = null;
        return r;
    }

    protected Binding moveToNextBindingOrNull() {
        Binding r2;
        switch (this.state) {
            case DONE: {
                return null;
            }
            case HASH: 
            case INIT: {
                throw new IllegalStateException();
            }
            case TRAILER: {
                return this.doOneTail();
            }
        }
        while (true) {
            if (this.iterCurrent == null) {
                if (!this.iterStream.hasNext()) {
                    this.state = Phase.TRAILER;
                    this.iterTail = this.joinFinished();
                    if (this.iterTail != null) {
                        return this.doOneTail();
                    }
                    return null;
                }
                this.rowStream = (Binding)this.iterStream.next();
                ++this.s_countScan;
                this.iterCurrent = this.hashTable.getCandidates(this.rowStream);
                this.yielded = false;
                continue;
            }
            if (!this.iterCurrent.hasNext()) {
                Binding b;
                this.iterCurrent = null;
                if (this.yielded || (b = this.noYieldedRows(this.rowStream)) == null) continue;
                ++this.s_countScan;
                return b;
            }
            Binding rowCurrentProbe = this.iterCurrent.next();
            Binding r = Algebra.merge(rowCurrentProbe, this.rowStream);
            r2 = null;
            if (r != null) {
                r2 = this.yieldOneResult(rowCurrentProbe, this.rowStream, r);
            }
            if (r2 != null) break;
        }
        this.yielded = true;
        ++this.s_countResults;
        return r2;
    }

    private Binding doOneTail() {
        if (this.iterTail.hasNext()) {
            ++this.s_countResults;
            ++this.s_trailerResults;
            return this.iterTail.next();
        }
        this.state = Phase.DONE;
        this.iterTail = null;
        return null;
    }

    protected abstract Binding yieldOneResult(Binding var1, Binding var2, Binding var3);

    protected abstract Binding noYieldedRows(Binding var1);

    protected abstract QueryIterator joinFinished();

    @Override
    protected void closeSubIterator() {
        this.iterStream.close();
        this.hashTable.clear();
    }

    @Override
    protected void requestSubCancel() {
    }

    static enum Phase {
        INIT,
        HASH,
        STREAM,
        TRAILER,
        DONE;

    }
}

