/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.NodeConstraintComponent;
import org.apache.jena.shex.expressions.NodeConstraintVisitor;
import org.apache.jena.shex.expressions.NodeKind;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.ValidationContext;

public class NodeKindConstraint
extends NodeConstraintComponent {
    private NodeKind nodeKind;

    public NodeKindConstraint(NodeKind nodeKind) {
        this.nodeKind = nodeKind;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public ReportItem nodeSatisfies(ValidationContext vCxt, Node n) {
        switch (this.nodeKind) {
            case BNODE: {
                if (!n.isBlank()) break;
                return null;
            }
            case IRI: {
                if (!n.isURI()) break;
                return null;
            }
            case LITERAL: {
                if (!n.isLiteral()) break;
                return null;
            }
            case NONLITERAL: {
                if (n.isLiteral()) break;
                return null;
            }
        }
        String msg = this.toString() + " : Expected " + this.nodeKind.toString() + " for " + ShexLib.displayStr(n);
        return new ReportItem(msg, n);
    }

    @Override
    public void print(IndentedWriter out, NodeFormatter nFmt) {
        out.println(this.toString());
    }

    @Override
    public void visit(NodeConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "NodeKind: " + this.nodeKind.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeKind});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeKindConstraint other = (NodeKindConstraint)obj;
        return this.nodeKind == other.nodeKind;
    }
}

