/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.console;

import java.io.Console;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.text.MessageFormat;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.util.CachedAuthenticator;

public class ConsoleAuthenticator
extends CachedAuthenticator {
    private final Console cons = System.console();

    public static void install() {
        ConsoleAuthenticator c = new ConsoleAuthenticator();
        if (c.cons == null) {
            throw new NoClassDefFoundError(CLIText.get().noSystemConsoleAvailable);
        }
        Authenticator.setDefault((Authenticator)((Object)c));
    }

    protected PasswordAuthentication promptPasswordAuthentication() {
        String realm = this.formatRealm();
        String username = this.cons.readLine(MessageFormat.format(CLIText.get().usernameFor + " ", realm), new Object[0]);
        if (username == null || username.isEmpty()) {
            return null;
        }
        char[] password = this.cons.readPassword(CLIText.get().password + " ", new Object[0]);
        if (password == null) {
            password = new char[]{};
        }
        return new PasswordAuthentication(username, password);
    }

    private String formatRealm() {
        StringBuilder realm = new StringBuilder();
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
            realm.append((Object)this.getRequestorType());
            realm.append(" ");
            realm.append(this.getRequestingHost());
            if (this.getRequestingPort() > 0) {
                realm.append(":");
                realm.append(this.getRequestingPort());
            }
        } else {
            realm.append(this.getRequestingURL());
        }
        return realm.toString();
    }
}

