/*******************************************************************************
 * Copyright (c) 2018 Thomas Wolf <thomas.wolf@paranor.ch>
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.egit.ui.internal.selection;

import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jgit.lib.Repository;

/**
 * Represents a virtual "Repository" node. Real nodes should use
 * {@link org.eclipse.egit.ui.internal.repository.tree.RepositoryNode
 * RepositoryNode}.
 */
public class RepositoryVirtualNode extends RepositoryTreeNode<Repository> {

	/**
	 * Constructs the node.
	 *
	 * @param parent
	 *            the parent node (may be null)
	 * @param repository
	 *            the {@link Repository}
	 */
	public RepositoryVirtualNode(RepositoryTreeNode parent, Repository repository) {
		super(parent, RepositoryTreeNodeType.REPO, repository, repository);
	}

}
