/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.tagfiles.directives.general;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final String CONTEXT_ROOT = "/jsp_tagfile_directives_general_web";

    public URLClientIT() throws Exception {
        this.setContextRoot(CONTEXT_ROOT);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_tagfile_directives_general_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_tagfile_directives_general_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/positiveTaglib.tag", "tags/positiveTaglib.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/positiveIncludePageRelative.tag", "tags/positiveIncludePageRelative.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/positiveIncludeContextRelative.tag", "tags/positiveIncludeContextRelative.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/negativePageDirective.tag", "tags/negativePageDirective.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/negativeInclude.tag", "tags/negativeInclude.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/ErrorOnELNotFoundTrue.tag", "tags/ErrorOnELNotFoundTrue.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/ErrorOnELNotFoundFalse.tag", "tags/ErrorOnELNotFoundFalse.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/include/negativeInclude.tagf", "tags/include/negativeInclude.tagf");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/include/positiveIncludePageRelative.tagf", "tags/include/positiveIncludePageRelative.tagf");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/invoke/positiveTaglibInvokee.tag", "tags/invoke/positiveTaglibInvokee.tag");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveTaglib.jsp")), "positiveTaglib.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIncludePageRelative.jsp")), "positiveIncludePageRelative.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIncludeContextRelative.jsp")), "positiveIncludeContextRelative.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeVariableDirective.jsp")), "negativeVariableDirective.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeTagDirective.jsp")), "negativeTagDirective.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativePageDirective.jsp")), "negativePageDirective.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeInclude.jsp")), "negativeInclude.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeAttributeDirective.jsp")), "negativeAttributeDirective.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ErrorOnELNotFoundTrue.jsp")), "ErrorOnELNotFoundTrue.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ErrorOnELNotFoundFalse.jsp")), "ErrorOnELNotFoundFalse.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/include/positiveIncludeContextRelative.tagf")), "include/positiveIncludeContextRelative.tagf");
        return archive;
    }

    @Test
    public void negativePageDirectiveTest() throws Exception {
        String testName = "negativePageDirective";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeTagDirectiveTest() throws Exception {
        String testName = "negativeTagDirective";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeAttributeDirectiveTest() throws Exception {
        String testName = "negativeAttributeDirective";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeVariableDirectiveTest() throws Exception {
        String testName = "negativeVariableDirective";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void positiveIncludeContextRelativeTest() throws Exception {
        String testName = "positiveIncludeContextRelative";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void positiveIncludePageRelativeTest() throws Exception {
        String testName = "positiveIncludePageRelative";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void negativeIncludeTest() throws Exception {
        String testName = "negativeInclude";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void positiveTaglibTest() throws Exception {
        String testName = "positiveTaglib";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED|from invokee");
        this.invoke();
    }

    @Test
    public void errorOnELNotFoundFalseTest() throws Exception {
        String testName = "ErrorOnELNotFoundFalse";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.0");
        this.invoke();
    }

    @Test
    public void errorOnELNotFoundTrueTest() throws Exception {
        String testName = "ErrorOnELNotFoundTrue";
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_directives_general_web/" + testName + ".jsp HTTP/1.0");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

