/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.api.core.ActionException;
import org.glassfish.shoal.gms.api.core.CallBack;
import org.glassfish.shoal.gms.api.core.FailureRecoveryAction;
import org.glassfish.shoal.gms.api.core.FailureRecoverySignal;
import org.glassfish.shoal.gms.api.core.Signal;
import org.glassfish.shoal.gms.api.core.SignalAcquireException;
import org.glassfish.shoal.gms.api.core.SignalReleaseException;
import org.glassfish.shoal.gms.logging.GMSLogDomain;

public class FailureRecoveryActionImpl
implements FailureRecoveryAction {
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private CallBack caller;

    public FailureRecoveryActionImpl(CallBack caller) {
        this.caller = caller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeSignal(Signal signal) throws ActionException {
        boolean signalAcquired = false;
        String component = signal instanceof FailureRecoverySignal ? ((FailureRecoverySignal)signal).getComponentName() : "";
        try {
            signal.acquire();
            signalAcquired = true;
            this.logger.log(Level.FINE, component + ":Failure Recovery Signal acquired");
            this.notifyListeners(signal);
        }
        catch (SignalAcquireException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        finally {
            if (signalAcquired) {
                try {
                    signal.release();
                    this.logger.log(Level.FINE, component + ":Failure Recovery Signal released");
                }
                catch (SignalReleaseException e) {
                    this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private void notifyListeners(Signal signal) {
        this.caller.processNotification(signal);
    }
}

