/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.module.config;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.AuthConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.delegate.MessagePolicyDelegate;
import org.glassfish.epicyro.config.helper.EpochCarrier;

public abstract class BaseAuthConfigImpl
implements AuthConfig {
    private static final System.Logger LOG = System.getLogger(BaseAuthConfigImpl.class.getName());
    EpochCarrier providerEpoch;
    long epoch;
    MessagePolicyDelegate policyDelegate;
    String layer;
    String appContext;
    CallbackHandler callbackHandler;
    private final ReentrantReadWriteLock instanceReadWriteLock = new ReentrantReadWriteLock();
    private final Lock instanceReadLock = this.instanceReadWriteLock.readLock();
    private final Lock instanceWriteLock = this.instanceReadWriteLock.writeLock();

    public BaseAuthConfigImpl(EpochCarrier providerEpoch, MessagePolicyDelegate policyDelegate, String layer, String appContext, CallbackHandler callbackHandler) throws AuthException {
        this.providerEpoch = providerEpoch;
        this.policyDelegate = policyDelegate;
        this.layer = layer;
        this.appContext = appContext;
        this.callbackHandler = callbackHandler;
        this.initialize();
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return this.policyDelegate.getAuthContextID(messageInfo);
    }

    public void refresh() {
        try {
            this.initialize();
        }
        catch (AuthException ae) {
            throw new RuntimeException(ae);
        }
    }

    private void initialize() throws AuthException {
        this.instanceWriteLock.lock();
        try {
            this.epoch = this.providerEpoch.getEpoch();
            this.initializeContextMap();
        }
        finally {
            this.instanceWriteLock.unlock();
        }
    }

    private void doRefreshIfNeeded() {
        boolean hasChanged = false;
        this.instanceReadLock.lock();
        try {
            hasChanged = this.providerEpoch.hasChanged(this.epoch);
        }
        finally {
            this.instanceReadLock.unlock();
        }
        if (hasChanged) {
            this.refresh();
        }
    }

    private Integer getHashCode(Map<String, ?> properties) {
        if (properties == null) {
            return Integer.valueOf("0");
        }
        return properties.hashCode();
    }

    private <M> M getContextFromMap(Map<String, Map<Integer, M>> contextMap, String authContextID, Map<String, ?> properties) {
        M context = null;
        Map<Integer, M> internalMap = contextMap.get(authContextID);
        if (internalMap != null) {
            context = internalMap.get(this.getHashCode(properties));
        }
        if (context != null) {
            LOG.log(System.Logger.Level.DEBUG, "AuthContextID found in Map: {0}", authContextID);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <M> M getContext(Map<String, Map<Integer, M>> contextMap, String authContextID, Subject subject, Map<String, ?> properties) throws AuthException {
        Object context = null;
        this.doRefreshIfNeeded();
        this.instanceReadLock.lock();
        try {
            context = this.getContextFromMap(contextMap, authContextID, properties);
            if (context != null) {
                Object v = context;
                return (M)v;
            }
        }
        finally {
            this.instanceReadLock.unlock();
        }
        this.instanceWriteLock.lock();
        try {
            context = this.getContextFromMap(contextMap, authContextID, properties);
            if (context == null) {
                context = this.createAuthContext(authContextID, properties);
                Map<Integer, M> internalMap = contextMap.get(authContextID);
                if (internalMap == null) {
                    internalMap = new HashMap<Integer, M>();
                    contextMap.put(authContextID, internalMap);
                }
                internalMap.put(this.getHashCode(properties), context);
            }
            Object v = context;
            return (M)v;
        }
        finally {
            this.instanceWriteLock.unlock();
        }
    }

    protected void checkMessageTypes(Class<?>[] supportedMessageTypes) throws AuthException {
        Class<?>[] requiredMessageTypes;
        for (Class<?> requiredType : requiredMessageTypes = this.policyDelegate.getMessageTypes()) {
            boolean supported = false;
            for (Class<?> supportedType : supportedMessageTypes) {
                if (!requiredType.isAssignableFrom(supportedType)) continue;
                supported = true;
            }
            if (supported) continue;
            throw new AuthException("module does not support message type: " + requiredType.getName());
        }
    }

    protected abstract void initializeContextMap();

    protected abstract <M> M createAuthContext(String var1, Map<String, ?> var2) throws AuthException;
}

